/*
    Copyright (C) HWPORT.COM
    All rights reserved.
    Author: JAEHYUK CHO <mailto:minzkn@minzkn.com>
*/

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

static unsigned int test_rand(void);

int main(int s_argc, char **s_argv);

static unsigned int test_rand(void)
{
#if 0L /* system logic */
    static int s_rand_seed_init = 0;
    
    if(s_rand_seed_init == 0) {
        srand((unsigned int)time((time_t *)0));
        s_rand_seed_init = 1;
    }
 
    return((unsigned int)rand());
#else /* my logic */
    static int s_rand_seed_init = 0;
    static unsigned int s_rand_seed = 0u;

    if(s_rand_seed_init == 0) {
        s_rand_seed += (unsigned int)time((time_t *)0);
        s_rand_seed = (s_rand_seed * 0x015a4e35u) + 1u;
        s_rand_seed_init = 1;
    }
    
    s_rand_seed = (s_rand_seed * 0x015a4e35u) + 1u;
    return(((s_rand_seed >> 16) | (s_rand_seed << 16)) >> 1);
#endif
}

int main(int s_argc, char **s_argv)
{
    (void)s_argc;
    (void)s_argv;

    (void)fprintf(stdout, "BEGIN TEST...\n");

    do {
#if 0L
# define def_test_loop (100u)
#else /* infinity */
# define def_test_loop ((~0u) >> 1)
#endif
        unsigned int s_scale, s_scale_xx2;
        unsigned int s_loops, s_confidence_level, s_piece;
        unsigned int s_x, s_y, s_mine;

        s_scale = 1448u;
        s_scale_xx2 = s_scale * s_scale;

        s_piece = 0u;
        s_mine = 0u;

        s_loops = (s_argc >= 2) ? ((unsigned int)atoi(s_argv[1])) : def_test_loop;
        for(s_confidence_level=0u;s_confidence_level < s_loops;) {
            s_x = test_rand() % s_scale;
            s_y = test_rand() % s_scale;
            if(((s_x * s_x) + (s_y * s_y)) <= s_scale_xx2) {
                ++s_mine;
            }

            if((++s_piece) < 4u) {
                continue;
            }
            s_piece = 0u;

            ++s_confidence_level;

            (void)fprintf(stdout,
                "\r[%8u] x=%4u, y=%4u, P=%f",
                s_confidence_level,
                s_x, s_y,
                ((double)s_mine) / ((double)s_confidence_level)
            );
            (void)fflush(stdout);
        }

    }while(0);

    (void)fprintf(stdout, "\nEND TEST...\n");

    return(EXIT_SUCCESS);
}

/* vim: set expandtab: */
/* End of source */
