/*
 Copyright (C) JAEHYUK CHO
 All rights reserved.
 Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#if !defined(__def_mzapi_source_main_c__)
#define __def_mzapi_source_main_c__ "main.c"

#include "mzseed.h"

#if (!defined(HAVE_CONFIG_H)) || (defined(HAVE_CONFIG_H) && defined(HAVE_STDIO_H))
# include <stdio.h>
#endif
#if (!defined(HAVE_CONFIG_H)) || (defined(HAVE_CONFIG_H) && defined(HAVE_STDLIB_H))
# include <stdlib.h>
#endif
#if (!defined(HAVE_CONFIG_H)) || (defined(HAVE_CONFIG_H) && defined(HAVE_STRING_H))
# include <string.h>
#endif

#define __def_mzapi_show_round_key__ (1)

static void mzapi_dump(__mzapi_const__ void *s_data, int s_size);

static void test_seed_block(void);
static void test_seed_data_nopadding(void);
static void test_seed_data_padding(void);
static void test_seed_data_cfb8(void);
static void test_seed_data_ofb8(void);

int main(int s_argc, char **s_argv);

#if __def_mzapi_seed_rounds__ == (16)
__t_mzapi_byte__ __mzapi_const__ g_user_key[ __def_mzapi_seed_rounds__ ] = {
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
#else
__t_mzapi_byte__ __mzapi_const__ g_user_key[ __def_mzapi_seed_rounds__ ] = {0x00, };
#endif

static void mzapi_dump(__mzapi_const__ void *s_data, int s_size)
{
 int s_o,s_w,s_i;unsigned char s_b[17];
 if(((__mzapi_const__ void *)(s_data))==NULL)return;s_b[16]='\0';s_o=(int)0;
 while(s_o<(s_size)){
  s_w=((s_size)-s_o)<16?((s_size)-s_o):16;printf("%08X",s_o);for(s_i=0;s_i<s_w;s_i++){if(s_i==8)printf(" | ");else printf(" ");
  s_b[s_i]=*(((__mzapi_const__ unsigned char *)(s_data))+s_o+s_i);printf("%02X",s_b[s_i]);if((s_b[s_i]&0x80)||(s_b[s_i]<' '))s_b[s_i]='.';}
  while(s_i<16){if(s_i==8)printf("     ");else printf("   ");s_b[s_i]=' ';s_i++;}
  printf(" [%s]\n",(char *)s_b);s_o+=16;}
}

static void test_seed_block(void)
{
 __t_mzapi_dword__ s_round_key[ __def_mzapi_seed_round_keys__ ];
 __t_mzapi_byte__ s_data[ __def_mzapi_seed_block_size__ ] = {
  0xf0, 0xe1, 0xd2, 0xc3, 0xb4, 0xa5, 0x96, 0x87, 
  0x78, 0x69, 0x5a, 0x4b, 0x3c, 0x2d, 0x1e, 0x0f
 };

 (void)fprintf(stdout, "test seed block\n~~~~~~~~~~~~~~~\n\n");
 
 (void)fprintf(stdout, "user_key:\n");
 mzapi_dump((__mzapi_const__ void *)(&g_user_key[0]), (int)sizeof(g_user_key));
 
 (void)fprintf(stdout, "\ndata:\n");
 mzapi_dump(s_data, (int)sizeof(s_data));
 
 (__t_mzapi_void__)mzapi_seed_make_round_key((__t_mzapi_ptr__)(&s_round_key[0]), (__mzapi_const__ __t_mzapi_ptr__)(&g_user_key[0]));

 (void)fprintf(stdout, "\nencrypt_block:\n");
 mzapi_dump(mzapi_seed_encrypt_block((__t_mzapi_ptr__)(&s_data[0]), (__t_mzapi_ptr__)(&s_round_key[0])), (int)sizeof(s_data));
 
 (void)fprintf(stdout, "\ndecrypt_block:\n");
 mzapi_dump(mzapi_seed_decrypt_block((__t_mzapi_ptr__)(&s_data[0]), (__t_mzapi_ptr__)(&s_round_key[0])), (int)sizeof(s_data));
 
#if __def_mzapi_show_round_key__ != (0)
 do
 {
  int s_index;
  (void)fprintf(stdout, "\nround key:\n");
  for(s_index = 0;s_index < ((int)sizeof(g_user_key));s_index++)
  {
   (void)fprintf(stdout, 
    "\tK%02d,0 : 0x%08lX\t"
    "K%02d,1 : 0x%08lX\n",
    s_index + 1, (unsigned long)s_round_key[s_index << 1],
    s_index + 1, (unsigned long)s_round_key[(s_index << 1) + 1]);
  }
 }while(0);
#endif

 (void)fprintf(stdout, "\n");
}

static void test_seed_data_nopadding(void)
{
 __t_mzapi_dword__ s_round_key[ __def_mzapi_seed_round_keys__ ];
 __t_mzapi_byte__ s_data[] = {
  "SEED encrypt/decrypt library/example source\n"
  "Copyright (C) JAEHYUK CHO\n"
  "All rights reserved.\n"
  "Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>\n"
 };
 __t_mzapi_size__ s_data_size;

 s_data_size = (__t_mzapi_size__)sizeof(s_data);
 
 (void)fprintf(stdout, "test seed data\n~~~~~~~~~~~~~~\n\n");
 
 (void)fprintf(stdout, "user_key:\n");
 mzapi_dump((__mzapi_const__ void *)(&g_user_key[0]), (int)sizeof(g_user_key));
 
 (void)fprintf(stdout, "\ndata:\n");
 mzapi_dump(s_data, (int)s_data_size);
 
 (__t_mzapi_void__)mzapi_seed_make_round_key((__t_mzapi_ptr__)(&s_round_key[0]), (__mzapi_const__ __t_mzapi_ptr__)(&g_user_key[0]));

 (void)fprintf(stdout, "\nencrypt:\n");
 mzapi_dump(mzapi_seed_encrypt((__t_mzapi_ptr__)(&s_data[0]), s_data_size, (__t_mzapi_ptr__)(&s_round_key[0])), (int)s_data_size);
 
 (void)fprintf(stdout, "\ndecrypt:\n");
 mzapi_dump(mzapi_seed_decrypt((__t_mzapi_ptr__)(&s_data[0]), s_data_size, (__t_mzapi_ptr__)(&s_round_key[0])), (int)s_data_size);

#if __def_mzapi_show_round_key__ != (0)
 do
 {
  int s_index;
  (void)fprintf(stdout, "\nround key:\n");
  for(s_index = 0;s_index < ((int)sizeof(g_user_key));s_index++)
  {
   (void)fprintf(stdout, 
    "\tK%02d,0 : 0x%08lX\t"
    "K%02d,1 : 0x%08lX\n",
    s_index + 1, (unsigned long)s_round_key[s_index << 1],
    s_index + 1, (unsigned long)s_round_key[(s_index << 1) + 1]);
  }
 }while(0);
#endif
 
 (void)fprintf(stdout, "\n");
}

static void test_seed_data_padding(void)
{
 __t_mzapi_dword__ s_round_key[ __def_mzapi_seed_round_keys__ ];
 __t_mzapi_byte__ s_data[] = {
  "SEED encrypt/decrypt library/example source\n"
  "Copyright (C) JAEHYUK CHO\n"
  "All rights reserved.\n"
  "Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>\n"
 };
 __t_mzapi_size__ s_data_size;
 __t_mzapi_ptr__ s_padding_data;
 __t_mzapi_size__ s_padding_data_size;

 s_data_size = (__t_mzapi_size__)sizeof(s_data);
 
 (void)fprintf(stdout, "test seed data padding\n~~~~~~~~~~~~~~~~~~~~~~\n\n");
 
 s_padding_data_size = s_data_size + ((__t_mzapi_size__)(__def_mzapi_seed_block_size__ - 1));
 s_padding_data_size -= s_padding_data_size % ((__t_mzapi_size__)__def_mzapi_seed_block_size__);
 s_padding_data = (__t_mzapi_ptr__)malloc((size_t)s_padding_data_size);
 if(s_padding_data == ((__t_mzapi_ptr__)0))
 {
  (void)fprintf(stdout, "allocate error !\n");
  return;
 }
 (void)memcpy((void *)s_padding_data, (void *)s_data, (size_t)s_data_size);
 if((s_padding_data_size - s_data_size) > ((__t_mzapi_size__)0))
 { /* zero padding */
  (void)memset(__mzapi_peek_f__(void *, s_padding_data, s_data_size), 0, (size_t)(s_padding_data_size - s_data_size));
 }
 
 (void)fprintf(stdout, "user_key:\n");
 mzapi_dump((__mzapi_const__ void *)(&g_user_key[0]), (int)sizeof(g_user_key));
 
 (void)fprintf(stdout, "\ndata:\n");
 mzapi_dump(s_data, (int)s_data_size);
 
 (__t_mzapi_void__)mzapi_seed_make_round_key((__t_mzapi_ptr__)(&s_round_key[0]), (__mzapi_const__ __t_mzapi_ptr__)(&g_user_key[0]));

 (void)fprintf(stdout, "\nencrypt:\n");
 mzapi_dump(mzapi_seed_encrypt(s_padding_data, s_padding_data_size, (__t_mzapi_ptr__)(&s_round_key[0])), (int)s_padding_data_size);
 
 (void)fprintf(stdout, "\ndecrypt:\n");
 mzapi_dump(mzapi_seed_decrypt(s_padding_data, s_padding_data_size, (__t_mzapi_ptr__)(&s_round_key[0])), (int)s_data_size);
 
#if __def_mzapi_show_round_key__ != (0)
 do
 {
  int s_index;
  (void)fprintf(stdout, "\nround key:\n");
  for(s_index = 0;s_index < ((int)sizeof(g_user_key));s_index++)
  {
   (void)fprintf(stdout, 
    "\tK%02d,0 : 0x%08lX\t"
    "K%02d,1 : 0x%08lX\n",
    s_index + 1, (unsigned long)s_round_key[s_index << 1],
    s_index + 1, (unsigned long)s_round_key[(s_index << 1) + 1]);
  }
 }while(0);
#endif

 (void)fprintf(stdout, "\n");

 free((void *)s_padding_data);
}

static void test_seed_data_cfb8(void)
{
 static __mzapi_const__ __t_mzapi_byte__ s_initial_vector[ __def_mzapi_seed_block_size__ ] = {
  0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff
 };
 __t_mzapi_byte__ s_iv[ __def_mzapi_seed_block_size__ ];
 __t_mzapi_dword__ s_round_key[ __def_mzapi_seed_round_keys__ ];
 __t_mzapi_byte__ s_data[] = {
  "SEED encrypt/decrypt library/example source\n"
  "Copyright (C) JAEHYUK CHO\n"
  "All rights reserved.\n"
  "Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>\n"
 };
 __t_mzapi_size__ s_data_size;

 s_data_size = (__t_mzapi_size__)sizeof(s_data);
 
 (void)fprintf(stdout, "test seed data cfb8\n~~~~~~~~~~~~~~\n\n");
 
 (void)fprintf(stdout, "user_key:\n");
 mzapi_dump((__mzapi_const__ void *)(&g_user_key[0]), (int)sizeof(g_user_key));
 
 (void)fprintf(stdout, "\ndata:\n");
 mzapi_dump(s_data, (int)s_data_size);
 
 (__t_mzapi_void__)mzapi_seed_make_round_key((__t_mzapi_ptr__)(&s_round_key[0]), (__mzapi_const__ __t_mzapi_ptr__)(&g_user_key[0]));

 (void)fprintf(stdout, "\nencrypt:\n");
 mzapi_dump(mzapi_seed_encrypt_cfb8((__t_mzapi_ptr__)(&s_data[0]), s_data_size, (__t_mzapi_ptr__)memcpy((void *)(&s_iv[0]), (__mzapi_const__ void *)(&s_initial_vector[0]), sizeof(s_iv)), (__t_mzapi_ptr__)(&s_round_key[0])), (int)s_data_size);
 
 (void)fprintf(stdout, "\ndecrypt:\n");
 mzapi_dump(mzapi_seed_decrypt_cfb8((__t_mzapi_ptr__)(&s_data[0]), s_data_size, (__t_mzapi_ptr__)memcpy((void *)(&s_iv[0]), (__mzapi_const__ void *)(&s_initial_vector[0]), sizeof(s_iv)), (__t_mzapi_ptr__)(&s_round_key[0])), (int)s_data_size);

#if __def_mzapi_show_round_key__ != (0)
 do
 {
  int s_index;
  (void)fprintf(stdout, "\nround key:\n");
  for(s_index = 0;s_index < ((int)sizeof(g_user_key));s_index++)
  {
   (void)fprintf(stdout, 
    "\tK%02d,0 : 0x%08lX\t"
    "K%02d,1 : 0x%08lX\n",
    s_index + 1, (unsigned long)s_round_key[s_index << 1],
    s_index + 1, (unsigned long)s_round_key[(s_index << 1) + 1]);
  }
 }while(0);
#endif
 
 (void)fprintf(stdout, "\n");
}

static void test_seed_data_ofb8(void)
{
 static __mzapi_const__ __t_mzapi_byte__ s_initial_vector[ __def_mzapi_seed_block_size__ ] = {
  0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff
 };
 __t_mzapi_byte__ s_iv[ __def_mzapi_seed_block_size__ ];
 __t_mzapi_dword__ s_round_key[ __def_mzapi_seed_round_keys__ ];
 __t_mzapi_byte__ s_data[] = {
  "SEED encrypt/decrypt library/example source\n"
  "Copyright (C) JAEHYUK CHO\n"
  "All rights reserved.\n"
  "Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>\n"
 };
 __t_mzapi_size__ s_data_size;

 s_data_size = (__t_mzapi_size__)sizeof(s_data);
 
 (void)fprintf(stdout, "test seed data ofb8\n~~~~~~~~~~~~~~\n\n");
 
 (void)fprintf(stdout, "user_key:\n");
 mzapi_dump((__mzapi_const__ void *)(&g_user_key[0]), (int)sizeof(g_user_key));
 
 (void)fprintf(stdout, "\ndata:\n");
 mzapi_dump(s_data, (int)s_data_size);
 
 (__t_mzapi_void__)mzapi_seed_make_round_key((__t_mzapi_ptr__)(&s_round_key[0]), (__mzapi_const__ __t_mzapi_ptr__)(&g_user_key[0]));

 (void)fprintf(stdout, "\nencrypt:\n");
 mzapi_dump(mzapi_seed_encrypt_ofb8((__t_mzapi_ptr__)(&s_data[0]), s_data_size, (__t_mzapi_ptr__)memcpy((void *)(&s_iv[0]), (__mzapi_const__ void *)(&s_initial_vector[0]), sizeof(s_iv)), (__t_mzapi_ptr__)(&s_round_key[0])), (int)s_data_size);
 
 (void)fprintf(stdout, "\ndecrypt:\n");
 mzapi_dump(mzapi_seed_decrypt_ofb8((__t_mzapi_ptr__)(&s_data[0]), s_data_size, (__t_mzapi_ptr__)memcpy((void *)(&s_iv[0]), (__mzapi_const__ void *)(&s_initial_vector[0]), sizeof(s_iv)), (__t_mzapi_ptr__)(&s_round_key[0])), (int)s_data_size);

#if __def_mzapi_show_round_key__ != (0)
 do
 {
  int s_index;
  (void)fprintf(stdout, "\nround key:\n");
  for(s_index = 0;s_index < ((int)sizeof(g_user_key));s_index++)
  {
   (void)fprintf(stdout, 
    "\tK%02d,0 : 0x%08lX\t"
    "K%02d,1 : 0x%08lX\n",
    s_index + 1, (unsigned long)s_round_key[s_index << 1],
    s_index + 1, (unsigned long)s_round_key[(s_index << 1) + 1]);
  }
 }while(0);
#endif
 
 (void)fprintf(stdout, "\n");
}

int main(int s_argc, char **s_argv)
{
 (void)s_argc;
 (void)s_argv;
#if 1
 test_seed_block();
#endif
#if 1
 test_seed_data_nopadding();
#endif
#if 1
 test_seed_data_padding();
#endif
#if 1
 test_seed_data_cfb8();
#endif
#if 1
 test_seed_data_ofb8();
#endif
 return(0);
}

#endif

/* vim: set expandtab: */
/* End of source */
