/*
  Copyright (C) JAEHYUK CHO
  All rights reserved.
  Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#define mzapi_import                                                 extern
#define mzapi_export

#if defined(__GNUC__)
# if 0
#  define mzapi_fastcall                                             __attribute__((stdcall))
# else
#  define mzapi_fastcall
# endif
#else
# define mzapi_fastcall
#endif

typedef unsigned long t_mzapi_crc32;
typedef void * t_mzapi_vector;
#define t_mzapi_hash_key t_mzapi_crc32

struct ts_mzapi_hash_node
{
 struct ts_mzapi_hash_node *prev;
 struct ts_mzapi_hash_node *next;
 t_mzapi_hash_key key;
 t_mzapi_vector vector;
};

struct ts_mzapi_hash
{
 int table_count;
 size_t table_size;
 t_mzapi_hash_key seed;
 struct ts_mzapi_hash_node **head;
 struct ts_mzapi_hash_node **tail;
 /* member function */
 t_mzapi_hash_key (mzapi_fastcall * function)(struct ts_mzapi_hash *, const void *, size_t);
 int (mzapi_fastcall * index)(t_mzapi_hash_key, int);
 struct ts_mzapi_hash_node * (mzapi_fastcall * search_by_key)(struct ts_mzapi_hash *, t_mzapi_hash_key);
 struct ts_mzapi_hash_node * (mzapi_fastcall * next_search)(struct ts_mzapi_hash *, struct ts_mzapi_hash_node *);
 struct ts_mzapi_hash_node * (mzapi_fastcall * prev_search)(struct ts_mzapi_hash *, struct ts_mzapi_hash_node *);
 struct ts_mzapi_hash_node * (mzapi_fastcall * add)(struct ts_mzapi_hash *, t_mzapi_hash_key, t_mzapi_vector);
 int (mzapi_fastcall * del)(struct ts_mzapi_hash *, struct ts_mzapi_hash_node *);
 int (mzapi_fastcall * info)(struct ts_mzapi_hash *);
};

#if !defined(__def_test_library_source_hash_c__)
mzapi_import struct ts_mzapi_hash * (mzapi_fastcall mzapi_open_hash)(int s_table_count);
mzapi_import struct ts_mzapi_hash * (mzapi_fastcall mzapi_close_hash)(struct ts_mzapi_hash *s_hash);
#endif

/* vim: set expandtab: */
/* End of source */
