/*

  Original program is mpg123 
   
  Code revision by JaeHyuk << KOREA >>
  minzkn@infoeq.co.kr
 
 */

#if !defined(DEF_mpg123_h)
#define DEF_mpg123_h "mpg123.h"

#include        <stdio.h>
#include        <string.h>
#include        <signal.h>
#include        <sys/signal.h>
#include        <unistd.h>

#include        <math.h>

#include        "mp3_ext.h"

#define M_PI       3.14159265358979323846
#define M_SQRT2	1.41421356237309504880

#ifdef REAL_IS_FIXED
#define real long

#define REAL_RADIX		15
#define REAL_FACTOR		(32.0 * 1024.0)

#define REAL_PLUS_32767	( 32767 << REAL_RADIX )
#define REAL_MINUS_32768	( -32768 << REAL_RADIX )

#define DOUBLE_TO_REAL(x)	((int)((x) * REAL_FACTOR))
#define REAL_TO_SHORT(x)	((x) >> REAL_RADIX)
#define REAL_MUL(x, y)		(((long long)(x) * (long long)(y)) >> REAL_RADIX)
#endif

#ifndef real
# define real float
#endif


#ifndef DOUBLE_TO_REAL
# define DOUBLE_TO_REAL(x)	(x)
#endif

#ifndef REAL_TO_SHORT
# define REAL_TO_SHORT(x)	(x)
#endif

#ifndef REAL_PLUS_32767
# define REAL_PLUS_32767	32767.0
#endif

#ifndef REAL_MINUS_32768
# define REAL_MINUS_32768	-32768.0
#endif

#ifndef REAL_MUL
# define REAL_MUL(x, y)		((x) * (y))
#endif


#define         SBLIMIT                 32
#define         SCALE_BLOCK             12
#define         SSLIMIT                 18
#define         MPG_MD_JOINT_STEREO     1
#define         MPG_MD_MONO             3

#if 0
struct al_table
{
 short bits;
 short d;
};
#endif

struct frame {
#if 0
    struct al_table *alloc;
#endif
    int stereo;
    int jsbound;
    int single;
    int II_sblimit;
    int down_sample_sblimit;
    int lsf;
    int mpeg25;
    int lay;
    int (*do_layer_b)(struct frame *fr,unsigned char *pcm_sample,int *pcm_point);
    int error_protection;
    int bitrate_index;
    int sampling_frequency;
    int padding;
    int extension;
    int mode;
    int mode_ext;
    int framesize; 
};

#define MAXFRAMESIZE 1792
struct mpstr {
	    t_MZ_Buffer *Buffer;
            int framesize;
            int fsizeold;
            struct frame fr;
            unsigned char bsspace[2][MAXFRAMESIZE+512]; 
            real hybrid_block[2][2][SBLIMIT*SSLIMIT];
            int hybrid_blc[2];
            unsigned long header;
            int bsnum;
            real synth_buffs[2][2][0x110];
	    int SkipByte;
	    unsigned char TAG[128];
};

#define MP3_ERR       (-1)
#define MP3_OK        (0)
#define MP3_NEED_MORE (1)
#define MP3_RESET     (2)

extern void initbitloader(unsigned char *s_WordPointer, int s_BitIndex);
extern unsigned char *getbitloader(void);
extern unsigned int   get1bit(void);
extern unsigned int   getbits(int);
extern unsigned int   getbits_fast(int);
extern void           backbits(int);
extern int            getbitoffset(void);
extern int            getbyte(void);

struct gr_info_s 
{
 int scfsi;
 unsigned part2_3_length;
 unsigned big_values;
 unsigned scalefac_compress;
 unsigned block_type;
 unsigned mixed_block_flag;
 unsigned table_select[3];
 unsigned subblock_gain[3];
 unsigned maxband[3];
 unsigned maxbandl;
 unsigned maxb;
 unsigned region1start;
 unsigned region2start;
 unsigned preflag;
 unsigned scalefac_scale;
 unsigned count1table_select;
 real *full_gain[3];
 real *pow2gain;
};

extern int do_layer3_b(struct frame *fr,unsigned char *pcm_sample,int *pcm_point);
extern int synth_1to1_pent (real *,int,unsigned char *);
extern int synth_1to1 (real *,int,unsigned char *,int *);
extern int synth_1to1_mono (real *,unsigned char *,int *);
extern void init_layer3(int);

extern long g_Frequency[9];
extern real muls[27][64];
extern real decwin[512+32];
extern real *pnts[5];

extern struct mpstr *gmp;

/* API */
extern int InitMP3(struct mpstr *mp);
extern int decodeMP3(struct mpstr *mp,char *inmemory,int inmemsize, char *outmemory,int *done);
extern void ExitMP3(struct mpstr *mp);

#endif

/* End of source */
