/*
  Copyright (C) JAEHYUK CHO
  All rights reserved.
  Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#include <sys/types.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

#include <linux/fb.h>

static int (mz_fbinfo)(const char *s_device)
{
 int s_result = 0, s_handle;
 struct fb_fix_screeninfo s_fix; 
 struct fb_var_screeninfo s_var; 
 s_handle = open(s_device == ((char *)0) ? "/dev/fb" : s_device, O_RDWR);
 if(s_handle != ((int)(-1)))
 {
  if((ioctl((int)s_handle, FBIOGET_FSCREENINFO, (&s_fix)) == 0) && (ioctl((int)s_handle, FBIOGET_VSCREENINFO, (&s_var)) == 0))
  {
   (void)printf("Frame buffer information.\n");
   (void)printf("~~~~~~~~~~~~~~~~~~~~~~~~~\n");
   (void)printf("\tfix.id               = %s\n", (char *)(&s_fix.id[0]));
   (void)printf("\tfix.smem_start       = %08lXH\n", (unsigned long)s_fix.smem_start);
   (void)printf("\tfix.smem_len         = %lu bytes\n", (unsigned long)s_fix.smem_len);
   (void)printf("\tfix.type             = %08lXH\n", (unsigned long)s_fix.type);
   (void)printf("\tfix.type_aux         = %08lXH\n", (unsigned long)s_fix.type_aux);
   (void)printf("\tfix.visual           = %08lXH\n", (unsigned long)s_fix.visual);
   (void)printf("\tfix.xpanstep         = %lu\n", (unsigned long)s_fix.xpanstep);
   (void)printf("\tfix.ypanstep         = %lu\n", (unsigned long)s_fix.ypanstep);
   (void)printf("\tfix.ywrapstep        = %lu\n", (unsigned long)s_fix.ywrapstep);
   (void)printf("\tfix.line_length      = %lu bytes\n", (unsigned long)s_fix.line_length);
   (void)printf("\tfix.mmio_start       = %08lXH\n", (unsigned long)s_fix.mmio_start);
   (void)printf("\tfix.mmio_len         = %lu bytes\n", (unsigned long)s_fix.mmio_len);
   (void)printf("\tfix.accel            = %08lXH\n", (unsigned long)s_fix.accel);
   (void)printf("\n");
   (void)printf("\tvar.xres             = %lu\n", (unsigned long)s_var.xres);
   (void)printf("\tvar.yres             = %lu\n", (unsigned long)s_var.yres);
   (void)printf("\tvar.xres_virtual     = %lu\n", (unsigned long)s_var.xres_virtual);
   (void)printf("\tvar.yres_virtual     = %lu\n", (unsigned long)s_var.yres_virtual);
   (void)printf("\tvar.xoffset          = %lu\n", (unsigned long)s_var.xoffset);
   (void)printf("\tvar.yoffset          = %lu\n", (unsigned long)s_var.yoffset);
   (void)printf("\tvar.bits_per_pixel   = %lu bpp\n", (unsigned long)s_var.bits_per_pixel);
   (void)printf("\tvar.grayscale        = %lu\n", (unsigned long)s_var.grayscale);
   (void)printf("\tvar.red              = offset:%lu, length:%lu, msb_right:%lu\n", 
    (unsigned long)s_var.red.offset, (unsigned long)s_var.red.length, (unsigned long)s_var.red.msb_right);
   (void)printf("\tvar.green            = offset:%lu, length:%lu, msb_right:%lu\n", 
    (unsigned long)s_var.green.offset, (unsigned long)s_var.green.length, (unsigned long)s_var.green.msb_right);
   (void)printf("\tvar.blue             = offset:%lu, length:%lu, msb_right:%lu\n", 
    (unsigned long)s_var.blue.offset, (unsigned long)s_var.blue.length, (unsigned long)s_var.blue.msb_right);
   (void)printf("\tvar.transp           = offset:%lu, length:%lu, msb_right:%lu\n", 
    (unsigned long)s_var.transp.offset, (unsigned long)s_var.transp.length, (unsigned long)s_var.transp.msb_right);
   (void)printf("\tvar.nonstd           = %08lXH\n", (unsigned long)s_var.nonstd);
   (void)printf("\tvar.activate         = %08lXH\n", (unsigned long)s_var.activate);
   (void)printf("\tvar.height           = %lu\n", (unsigned long)s_var.height);
   (void)printf("\tvar.width            = %lu\n", (unsigned long)s_var.width);
   (void)printf("\tvar.accel_flags      = %08lXH\n", (unsigned long)s_var.accel_flags);
   (void)printf("\tvar.pixclock         = %lu\n", (unsigned long)s_var.pixclock);
   (void)printf("\tvar.left_margin      = %lu\n", (unsigned long)s_var.left_margin);
   (void)printf("\tvar.right_margin     = %lu\n", (unsigned long)s_var.right_margin);
   (void)printf("\tvar.upper_margin     = %lu\n", (unsigned long)s_var.upper_margin);
   (void)printf("\tvar.lower_margin     = %lu\n", (unsigned long)s_var.lower_margin);
   (void)printf("\tvar.hsync_len        = %lu\n", (unsigned long)s_var.hsync_len);
   (void)printf("\tvar.vsync_len        = %lu\n", (unsigned long)s_var.vsync_len);
   (void)printf("\tvar.sync             = %lu\n", (unsigned long)s_var.sync);
   (void)printf("\tvar.vmode            = %08lXH\n", (unsigned long)s_var.vmode);
   s_result = 1;
  }
  else (void)perror("ioctl");
  (void)close(s_handle);
 }
 else (void)perror("open");
 return(s_result);
}

int main(int s_argc, char **s_argv)
{
 if(mz_fbinfo((s_argc >= 2) ? s_argv[1] : ((char *)0)) <= 0)(void)printf("usage: %s <fbdev>\n", s_argv[0]);
 return(0);
}

/* vim: set expandtab: */
/* End of source */
