/*
 Copyright (C) JAEHYUK CHO
 All rights reserved.
 Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#if !defined(__def_mzapi_header_mzseed_h__)
#define __def_mzapi_header_mzseed_h__ "mzseed.h"

#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if (!defined(HAVE_CONFIG_H)) || (defined(HAVE_CONFIG_H) && defined(HAVE_STRING_H))
# include <string.h>
#endif

#if !defined(__t_mzapi_dword__)
# define __t_mzapi_dword__ unsigned int
#endif

#if !defined(__t_mzapi_byte__)
# define __t_mzapi_byte__ unsigned char
#endif

#if !defined(__t_mzapi_int__)
# define __t_mzapi_int__ int
#endif

#if !defined(__t_mzapi_void__)
# define __t_mzapi_void__ void
#endif

#if !defined(__t_mzapi_ptr__)
# define __t_mzapi_ptr__ __t_mzapi_void__ *
#endif

#if !defined(__t_mzapi_size__)
# if defined(size_t)
#  define __t_mzapi_size__ size_t
# else
#  define __t_mzapi_size__ unsigned int
# endif
#endif

#if !defined(__mzapi_const__)
# define __mzapi_const__ const
#endif

#if !defined(__mzapi_fastcall__)
# define __mzapi_fastcall__
#endif

#if !defined(__mzapi_static__)
# define __mzapi_static__ static
#endif

#if !defined(__mzapi_export__)
# if defined(WIN32) || defined(_WIN32)
#  define __mzapi_export__ __declspec(dllexport)
# else
#  define __mzapi_export__
# endif
#endif

#if !defined(__mzapi_import__)
# if defined(WIN32) || defined(_WIN32)
#  define __mzapi_import__ extern __declspec(dllimport)
# else
#  define __mzapi_import__ extern
# endif
#endif

#if !defined(__mzapi_peek_f__)
# define __mzapi_peek_f__(m_cast,m_base,m_offset) ((m_cast)(((__t_mzapi_byte__ *)(m_base)) + (m_offset)))
#endif

#if !defined(__mzapi_peek_const_f__)
# define __mzapi_peek_const_f__(m_cast,m_base,m_offset) ((m_cast)(((const __t_mzapi_byte__ *)(m_base)) + (m_offset)))
#endif

#define __def_mzapi_seed_rounds__ (16) /* 2, 4, 6, ... 16 */
#define __def_mzapi_seed_round_keys__ (__def_mzapi_seed_rounds__ << 1)
#define __def_mzapi_seed_block_size__ (16)

#if defined(__cplusplus)
extern "C" {
#endif

#if !defined(__def_mzapi_source_mzseed_c__)
__mzapi_import__ __t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_seed_make_round_key)(__t_mzapi_ptr__ s_round_key, __mzapi_const__ __t_mzapi_ptr__ s_user_key);
__mzapi_import__ __t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_seed_encrypt_block)(__t_mzapi_ptr__ s_data, __mzapi_const__ __t_mzapi_ptr__ s_round_key);
__mzapi_import__ __t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_seed_decrypt_block)(__t_mzapi_ptr__ s_data, __mzapi_const__ __t_mzapi_ptr__ s_round_key);
__mzapi_import__ __t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_seed_encrypt)(__t_mzapi_ptr__ s_data, __t_mzapi_size__ s_size, __mzapi_const__ __t_mzapi_ptr__ s_round_key);
__mzapi_import__ __t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_seed_decrypt)(__t_mzapi_ptr__ s_data, __t_mzapi_size__ s_size, __mzapi_const__ __t_mzapi_ptr__ s_round_key);

__mzapi_import__ __t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_seed_encrypt_cfb8)(__t_mzapi_ptr__ s_data, __t_mzapi_size__ s_size, __t_mzapi_ptr__ s_initial_vector, __mzapi_const__ __t_mzapi_ptr__ s_round_key);
__mzapi_import__ __t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_seed_decrypt_cfb8)(__t_mzapi_ptr__ s_data, __t_mzapi_size__ s_size, __t_mzapi_ptr__ s_initial_vector, __mzapi_const__ __t_mzapi_ptr__ s_round_key);

__mzapi_import__ __t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_seed_encrypt_ofb8)(__t_mzapi_ptr__ s_data, __t_mzapi_size__ s_size, __t_mzapi_ptr__ s_initial_vector, __mzapi_const__ __t_mzapi_ptr__ s_round_key);
__mzapi_import__ __t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_seed_decrypt_ofb8)(__t_mzapi_ptr__ s_data, __t_mzapi_size__ s_size, __t_mzapi_ptr__ s_initial_vector, __mzapi_const__ __t_mzapi_ptr__ s_round_key);
#endif

#if defined(__cplusplus)
}
#endif

#endif

/* vim: set expandtab: */
/* End of source */
