/*
 [ GPL ]
 
 Code by JaeHyuk Cho <mailto:minzkn@minzkn.com> Made in KOREA

 http://www.minzkn.com
*/

#ifndef DEF_SOURCE_rdate_c 
#define DEF_SOURCE_rdate_c "rdate.c"

#ifndef DEF_STANDALONE
#define DEF_STANDALONE (0)
#endif

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include "rdate.h"

#if DEF_STANDALONE != (0)
#include <getopt.h>
#endif

static time_t __MZ_GetRemoteTime__(int s_Protocol, const char *s_RemoteIP, int s_RemotePort, int s_TimeOut, int s_TTL);
time_t MZ_GetRemoteTimeTCP(const char *s_RemoteIP, int s_RemotePort, int s_TimeOut);
time_t MZ_GetRemoteTimeUDP(const char *s_RemoteIP, int s_RemotePort, int s_TimeOut, int s_TTL);

/* [ Static function ] ==================================================================== */
static time_t __MZ_GetRemoteTime__(int s_Protocol, const char *s_RemoteIP, int s_RemotePort, int s_TimeOut, int s_TTL)
{
 const char *c_Protocol[] = {"tcp", "udp"};
 const char c_Service[] = "time";
 const char c_DefaultRemoteIP[] = "time.bora.net";
 time_t s_Return = (time_t)0;
 int s_Socket, s_Flags, s_SocketError, s_SocketErrorLength;
 unsigned long s_RemoteTime;
 socklen_t s_BindAddressLength, s_RemoteAddressLength;
 struct sockaddr_in s_BindAddress, s_RemoteAddress;
 struct hostent *s_HostEntry;
 struct protoent *s_ProtoEntry;
 struct servent *s_ServiceEntry;
 fd_set s_FD_Read, s_FD_Write;
 struct timeval s_TimeVal;
 if(s_RemotePort <= 0)
 {
  s_ServiceEntry = getservbyname(c_Service, c_Protocol[s_Protocol]);
  if(s_ServiceEntry)s_RemotePort = ntohs(s_ServiceEntry->s_port);
  else s_RemotePort = /* Default const TCP/UDP time port */37;
 }
 s_BindAddress.sin_family = AF_INET;
 s_BindAddress.sin_addr.s_addr = htonl(INADDR_ANY);
 s_BindAddress.sin_port = htons(0);
 memset((void *)(&s_BindAddress.sin_zero[0]), 0, sizeof(s_BindAddress.sin_zero));
 s_BindAddressLength = sizeof(s_BindAddress);
 s_RemoteAddress.sin_family = AF_INET;
 s_HostEntry = gethostbyname(s_RemoteIP ? s_RemoteIP : c_DefaultRemoteIP);
 if(s_HostEntry)s_RemoteAddress.sin_addr.s_addr = *((unsigned long *)s_HostEntry->h_addr);
 else s_RemoteAddress.sin_addr.s_addr = htonl(INADDR_ANY); 
 s_RemoteAddress.sin_port = htons(s_RemotePort);
 memset((void *)(&s_RemoteAddress.sin_zero[0]), 0, sizeof(s_RemoteAddress.sin_zero));
 s_RemoteAddressLength = sizeof(s_RemoteAddress);
 s_ProtoEntry = getprotobyname(c_Protocol[s_Protocol]);
 if(s_Protocol == /* TCP */0)
 {
  s_Socket = socket(AF_INET, SOCK_STREAM, s_ProtoEntry ? s_ProtoEntry->p_proto : 0);
  if(s_Socket >= 0)
  {
   s_Flags = fcntl(s_Socket, F_GETFL);
   if(fcntl(s_Socket, F_SETFL, s_Flags | O_NONBLOCK) == 0) /* For non-blocking connection */
   {
    if(bind(s_Socket, (struct sockaddr *)(&s_BindAddress), s_BindAddressLength) == 0)
    {
     if(connect(s_Socket, (struct sockaddr *)(&s_RemoteAddress), s_RemoteAddressLength) == 0)
     {
      L_NonBlock_Connection:;
      fcntl(s_Socket, F_SETFL, s_Flags);
      L_RecvTime:;
      s_TimeVal.tv_sec = (long)s_TimeOut;
      s_TimeVal.tv_usec = (long)0;
      FD_ZERO(&s_FD_Read);
      FD_SET(s_Socket, &s_FD_Read);
      if(select(s_Socket + 1, (fd_set *)(&s_FD_Read), (fd_set *)0, (fd_set *)0, s_TimeOut > 0 ? (struct timeval *)(&s_TimeVal) : (struct timeval *)0) > 0)
      {
       if(FD_ISSET(s_Socket, &s_FD_Read))
       {
        if(recv(s_Socket, (void *)(&s_RemoteTime), sizeof(s_RemoteTime), MSG_NOSIGNAL) == sizeof(s_RemoteTime))
        {
         s_Return = (time_t)(ntohl(s_RemoteTime) - /* RFC 868 */2208988800lu); /* Time entry 00:00:00 1 JAN 1970 GMT */
        }
       }
      }
     }
     else /* Wait for s_TimeOut */
     {
      s_TimeVal.tv_sec = (long)s_TimeOut;
      s_TimeVal.tv_usec = (long)0;
      FD_ZERO(&s_FD_Read);
      FD_ZERO(&s_FD_Write);
      FD_SET(s_Socket, &s_FD_Read);
      FD_SET(s_Socket, &s_FD_Write);
      if(select(s_Socket + 1, (fd_set *)(&s_FD_Read), (fd_set *)(&s_FD_Write), (fd_set *)0, s_TimeOut > 0 ? (struct timeval *)(&s_TimeVal) : (struct timeval *)0) > 0)
      {
       if(FD_ISSET(s_Socket, &s_FD_Read) || FD_ISSET(s_Socket, &s_FD_Write))
       {
	s_SocketErrorLength = sizeof(s_SocketError);
	if(getsockopt(s_Socket, SOL_SOCKET, SO_ERROR, &s_SocketError, &s_SocketErrorLength) == 0)
	{
	 if(s_SocketError == 0)goto L_NonBlock_Connection;
	}
       }
      }
     }
    }
   }
#ifdef WIN32
   closesocket(s_Socket);
#else
   close(s_Socket);
#endif
  } 
 }
 else /* if(s_Protocol == 1) */
 {
  s_Socket = socket(AF_INET, SOCK_DGRAM, s_ProtoEntry ? s_ProtoEntry->p_proto : 0);
  if(s_Socket >= 0)
  {
   if(s_TTL <= 0)s_TTL = /* Near TTL */16;
   if(setsockopt(s_Socket, IPPROTO_IP, IP_TTL, (char *)(&s_TTL), sizeof(s_TTL)) == 0)
   {
    if(bind(s_Socket, (struct sockaddr *)(&s_BindAddress), s_BindAddressLength) == 0)
    {
     s_RemoteTime = (unsigned long)0;
     if(sendto(s_Socket, (void *)(&s_RemoteTime), sizeof(s_RemoteTime), MSG_NOSIGNAL, (struct sockaddr *)(&s_RemoteAddress), s_RemoteAddressLength) == sizeof(s_RemoteTime))
     {
      goto L_RecvTime;
     }
    }
   }
#ifdef WIN32
   closesocket(s_Socket);
#else
   close(s_Socket);
#endif
  }
 }
 return(s_Return);
}

/* [ Public function ] ==================================================================== */
time_t MZ_GetRemoteTimeTCP(const char *s_RemoteIP, int s_RemotePort, int s_TimeOut)
{
 return(__MZ_GetRemoteTime__(/* TCP */0, s_RemoteIP, s_RemotePort, s_TimeOut, /* TTL */(-1)));
}

time_t MZ_GetRemoteTimeUDP(const char *s_RemoteIP, int s_RemotePort, int s_TimeOut, int s_TTL)
{
 return(__MZ_GetRemoteTime__(/* UDP */1, s_RemoteIP, s_RemotePort, s_TimeOut, s_TTL));
}

#if DEF_STANDALONE == (1)
int main(int s_Argc, char *s_Argv[])
{
 int s_Return, s_Index, s_Option, s_IsOption_h, s_IsOption_s, s_IsOption_p, s_IsOption_u;
 time_t s_RemoteTime;
 s_Return = 0;
 s_IsOption_h = s_IsOption_s = s_IsOption_p = s_IsOption_u = 0;
 if(s_Argc > 1)
 {
  do
  {
   s_Option = getopt(s_Argc, s_Argv, "hsup");
   if(s_Option > 0)
   {
    switch(s_Option)
    {
     case 'h': s_IsOption_h = 1; break;
     case 's': s_IsOption_s = 1; break;
     case 'u': s_IsOption_u = 1; break;
     case 'p': s_IsOption_p = 1; break;
     default: fprintf(stderr, "rdate: Unknown option \"-%c\"\n", s_Option); break;
    }
   }
  }while(s_Option > 0);
 }
 else s_IsOption_h = 1;
 s_RemoteTime = (time_t)0;
 s_Index = 1;
 while(s_Index < s_Argc)
 {
  if(s_Argv[s_Index][0] != '-')
  {
   if(s_IsOption_u == 0)s_RemoteTime = MZ_GetRemoteTimeTCP(s_Argv[s_Index], (-1), 8);
   else s_RemoteTime = MZ_GetRemoteTimeUDP(s_Argv[s_Index], (-1), 8, (-1));
   if(s_RemoteTime != (time_t)0)
   {
    if(s_IsOption_s == 1)
    {
     if(stime(&s_RemoteTime) != 0)perror("rdate");
    }
    if(s_IsOption_s == 0 || s_IsOption_p == 1)fprintf(stdout, "rdate: [%s]  %s\n", s_Argv[s_Index], ctime(&s_RemoteTime));
   }
   else fprintf(stderr, "rdate: Unknown host !\n");
  }
  s_Index++;
 }
 if(s_IsOption_h == 1 || s_RemoteTime == (time_t)0)
 {
  fprintf(stdout, "Get the time via the network (RFC868) - Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>\n"
		  "Usage: rdate [-s] [-p] [-u] host ...\n"
                  "       -h : Help usage\n"
                  "       -s : Set the system time to the returned time.\n"
                  "       -p : Print the time returned by the remote machine.\n"
                  "       -u : Use UDP instead of TCP as the transport.\n");
  if(s_IsOption_h == 0)s_Return = (-1);
 }
 return(s_Return);
}
#endif

#endif

/* End of source */
