/*
  Copyright (C) JAEHYUK CHO
  All rights reserved.
  Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <shadow.h>
#include <unistd.h>
#include <crypt.h>

#include "hash.h"

#define def_pwcrack_debug                                            (0) /* 0=no debug, 1=debug */
#define def_max_password_size                                        (8) /* 1 ~ */
#define def_start_password_size                                      (1) /* 1 ~ def_max_password_size */

struct ts_shadow
{
 struct ts_shadow *next;
 char *namp;
 char *pwdp;
 char salt[13];
};

static struct ts_shadow * (load_shadow)(struct ts_mzapi_hash *s_hash)
{
 struct ts_shadow *s_shadow = (struct ts_shadow *)0, *s_new;
 struct spwd *s_spwd;
 size_t s_pwdp_size;
 setspent();
 do
 {
  s_spwd = getspent();
  if(s_spwd == ((struct spwd *)0))break;
  s_new = (struct ts_shadow *)malloc((size_t)sizeof(struct ts_shadow));
  if(s_new == ((struct ts_shadow *)0))continue;
  s_new->next = s_shadow;
  s_new->namp = strdup(s_spwd->sp_namp);
  s_new->pwdp = strdup(s_spwd->sp_pwdp);
  s_pwdp_size = strlen(s_spwd->sp_pwdp);
  s_new->salt[0] = '\0';
  if(s_pwdp_size > ((size_t)0))
  {
   if(s_spwd->sp_pwdp[0] == '$')
   {
    if((s_pwdp_size > ((size_t)12)) && (s_spwd->sp_pwdp[2] == '$') && (s_spwd->sp_pwdp[11] == '$')) 
    {
     (void)memcpy((void *)(&s_new->salt[0]), (void *)(&s_spwd->sp_pwdp[0]), (size_t)12);
     s_new->salt[12] = '\0';
    }
   }
   else if(s_pwdp_size > ((size_t)2))
   {
    (void)memcpy((void *)(&s_new->salt[0]), (void *)(&s_spwd->sp_pwdp[0]), (size_t)2);
    s_new->salt[2] = '\0';
   }
  }
  s_shadow = s_new;
  (void)s_hash->add(s_hash, s_hash->function(s_hash, (void *)s_spwd->sp_namp, strlen(s_spwd->sp_namp)), (void *)s_new);
 }while(1);
 endspent();
 return(s_shadow);
}

static struct ts_shadow * (free_shadow)(struct ts_shadow *s_shadow)
{
 struct ts_shadow *s_prev;
 while(s_shadow != ((struct ts_shadow *)0))
 {
  s_prev = s_shadow;
  s_shadow = s_shadow->next;
  if(s_prev->pwdp != ((char *)0))free((void *)s_prev->pwdp);
  if(s_prev->namp != ((char *)0))free((void *)s_prev->namp);
  free((void *)s_prev);
 }
 return((struct ts_shadow *)0);
}

static int (verify_pwdp)(struct ts_shadow *s_this, const char *s_password)
{
#if def_pwcrack_debug != (0) /* DEBUG */
 (void)fprintf(stdout, "\rsearching password : \"%s\"%20s", s_password, " ");
 (void)fflush(stdout);
#else
 static char sg_roll[] = {'-', '\\', '|', '/'};
 static unsigned int sg_roll_tick = 0;
 sg_roll_tick++;
 if((sg_roll_tick % 1000u) == 0)
 {
  (void)fprintf(stdout, "%c[%s]\r", sg_roll[(sg_roll_tick / 1000u) % sizeof(sg_roll)], s_password);
  (void)fflush(stdout);
 }
#endif
 if(strcmp(s_this->pwdp, crypt(s_password, (char *)(&s_this->salt[0]))) == 0)
 {
  (void)fprintf(stdout, "detected password : \"\x1b[1;31m%s\x1b[0m\"\n", s_password);
  (void)fflush(stdout);
  return(1);
 }
 return(0);
}

static int (generate_self)(struct ts_shadow *s_this)
{
 return(verify_pwdp(s_this, s_this->namp));
}

static int (generate_dic)(struct ts_shadow *s_this, const char *s_pwdic_file)
{
 int s_result = 0;
 FILE *s_file;
 char s_password[ 1 << 10 ];
 size_t s_password_size;
 s_file = fopen(s_pwdic_file, "r");
 if(s_file != ((FILE *)0))
 {
  while(fgets((char *)(&s_password[0]), sizeof(s_password), s_file) != ((char *)0))
  {
   s_password_size = strlen((char *)(&s_password[0]));
   while(s_password_size > ((size_t)0))
   {
    s_password_size--;
    if((s_password[s_password_size] == '\n') || (s_password[s_password_size] == '\r'))s_password[s_password_size] = '\0';
   }
   s_result = verify_pwdp(s_this, (char *)(&s_password[0]));
   if(s_result != 0)break;
  }
  (void)fclose(s_file);
 }
 return(s_result);
}

static int (generate_word)(struct ts_shadow *s_this)
{
 static const char s_table[] = {
  '\0', /* dummy */
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
  '.', '/', ' '};
 int s_result = 0, s_table_index[ def_max_password_size + 1 ], s_password_offset = def_max_password_size - def_start_password_size, s_password_index;
 char s_password[ def_max_password_size + 1 ];
 for(s_password_index = 0;s_password_index <= def_max_password_size;s_password_index++)
 {
  s_table_index[s_password_index] = ((s_password_index >= (def_max_password_size - def_start_password_size)) && (s_password_index < (def_max_password_size - 1))) ? 1 : 0;
  s_password[s_password_index] = s_table[s_table_index[s_password_index]];
 }
 s_password_index = def_max_password_size - 1;
 do
 {
  if((++s_table_index[s_password_index]) < sizeof(s_table))
  {
   s_password[s_password_index] = s_table[s_table_index[s_password_index]];
   s_result = verify_pwdp(s_this, (char *)(&s_password[s_password_offset]));
   if(s_result != 0)break;
   s_password_index = def_max_password_size - 1;
  }
  else
  {
   s_table_index[s_password_index] = 1; 
   s_password[s_password_index] = s_table[1];
   if((--s_password_index) < 0)break;
   if(s_table_index[s_password_index] == '\0')s_password_offset--;
  }
 }while(1);
 return(s_result);
}

int main(int s_argc, char **s_argv)
{
 struct ts_mzapi_hash *s_shadow_hash;
 struct ts_shadow *s_shadow, *s_this = (struct ts_shadow *)0;
 struct ts_mzapi_hash_node *s_hash_node;
 struct passwd *s_password_entry;
 char *s_user;
 int s_check_all, s_index;
 s_shadow_hash = mzapi_open_hash(256);
 if(s_shadow_hash != ((struct ts_mzapi_hash *)0))
 {
  s_shadow = load_shadow(s_shadow_hash);
  if(s_shadow != ((struct ts_shadow *)0))
  {
   s_index = 1;
   if(s_argc >= 2)s_check_all = 0;
   else
   {
    s_check_all = 1;
    setpwent();
   }
   do
   {
    if(s_check_all != 0)
    {
     s_password_entry = getpwent();
     if(s_password_entry == ((struct passwd *)0))break;
     s_user = s_password_entry->pw_name;
    }
    else if(s_index < s_argc)s_user = s_argv[s_index++];
    else break;
    s_hash_node = s_shadow_hash->search_by_key(s_shadow_hash,
     s_shadow_hash->function(s_shadow_hash, (void *)s_user, strlen(s_user)));
    while(s_hash_node != ((struct ts_mzapi_hash_node *)0))
    {
     s_this = (struct ts_shadow *)s_hash_node->vector; 
     if(strcmp(s_user, s_this->namp) == 0)break;
     s_hash_node = s_shadow_hash->next_search(s_shadow_hash, s_hash_node);
    }
    if(s_hash_node != ((struct ts_mzapi_hash_node *)0))
    {
     (void)fprintf(stdout, "password crack : user=\"%s\", salt=\"%s\", pwdp=\"%s\"\n", s_user, (char *)(&s_this->salt[0]), s_this->pwdp);
     if(generate_self(s_this) == 0)
     {
      if(generate_dic(s_this, "./pwdic.txt") == 0)
      {
       if(s_check_all == 0)
       {
        if(generate_word(s_this) == 0)(void)fprintf(stdout, "\nnot found password\n");
       }
      }
     }
    }
    else if(s_check_all == 0)(void)fprintf(stdout, "not found user \"%s\"\n", s_user);
   }while(1);
   s_shadow = free_shadow(s_shadow);
  }
  else (void)fprintf(stdout, "error: shadow\n");
  s_shadow_hash = mzapi_close_hash(s_shadow_hash);
 }
 else (void)fprintf(stdout, "error: hash\n");
 return(0);
}

/* vim: set expandtab: */
/* End of source */
