/*
  Copyright (C) JAEHYUK CHO
  All rights reserved.
  Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <shadow.h>
#include <unistd.h>
#include <crypt.h>

#include "hash.h"

struct ts_shadow
{
 struct ts_shadow *next;
 char *namp;
 char *pwdp;
 char *crypt;
};

struct ts_shadow * (load_shadow)(struct ts_mzapi_hash *s_hash)
{
 struct ts_shadow *s_shadow = (struct ts_shadow *)0, *s_new;
 struct spwd *s_spwd;
 size_t s_pwdp_size;
 char s_salt[13];
 setspent();
 do
 {
  s_spwd = getspent();
  if(s_spwd == ((struct spwd *)0))break;
  s_new = (struct ts_shadow *)malloc((size_t)sizeof(struct ts_shadow));
  if(s_new == ((struct ts_shadow *)0))continue;
  s_new->next = s_shadow;
  s_new->namp = strdup(s_spwd->sp_namp);
  s_new->pwdp = strdup(s_spwd->sp_pwdp);
  s_pwdp_size = strlen(s_spwd->sp_pwdp);
  s_salt[0] = '\0';
  if(s_pwdp_size > ((size_t)0))
  {
   if(s_spwd->sp_pwdp[0] == '$')
   {
    if((s_pwdp_size > ((size_t)12)) && (s_spwd->sp_pwdp[2] == '$') && (s_spwd->sp_pwdp[11] == '$')) 
    {
     (void)memcpy((void *)(&s_salt[0]), (void *)(&s_spwd->sp_pwdp[0]), (size_t)12);
     s_salt[12] = '\0';
    }
   }
   else if(s_pwdp_size > ((size_t)2))
   {
    (void)memcpy((void *)(&s_salt[0]), (void *)(&s_spwd->sp_pwdp[0]), (size_t)2);
    s_salt[2] = '\0';
   }
  }
  s_new->crypt = strdup(crypt(s_spwd->sp_namp, (char *)(&s_salt[0])));
  s_shadow = s_new;
  (void)s_hash->add(s_hash, s_hash->function(s_hash, (void *)s_spwd->sp_namp, strlen(s_spwd->sp_namp)), (void *)s_new);
 }while(1);
 endspent();
 return(s_shadow);
}

struct ts_shadow * (free_shadow)(struct ts_shadow *s_shadow)
{
 struct ts_shadow *s_prev;
 while(s_shadow != ((struct ts_shadow *)0))
 {
  s_prev = s_shadow;
  s_shadow = s_shadow->next;
  if(s_prev->crypt != ((char *)0))free((void *)s_prev->crypt);
  if(s_prev->pwdp != ((char *)0))free((void *)s_prev->pwdp);
  if(s_prev->namp != ((char *)0))free((void *)s_prev->namp);
  free((void *)s_prev);
 }
 return((struct ts_shadow *)0);
}

int main(void)
{
 struct ts_mzapi_hash *s_shadow_hash;
 struct ts_shadow *s_shadow, *s_this = (struct ts_shadow *)0;
 struct passwd *s_passwd;
 struct ts_mzapi_hash_node *s_hash_node;
 s_shadow_hash = mzapi_open_hash(256);
 if(s_shadow_hash != ((struct ts_mzapi_hash *)0))
 {
  s_shadow = load_shadow(s_shadow_hash);
  if(s_shadow != ((struct ts_shadow *)0))
  {
   setpwent();
   do
   {
    s_passwd = getpwent();
    if(s_passwd == ((struct passwd *)0))break;
    s_hash_node = s_shadow_hash->search_by_key(s_shadow_hash,
     s_shadow_hash->function(s_shadow_hash, (void *)s_passwd->pw_name, strlen(s_passwd->pw_name)));
    while(s_hash_node != ((struct ts_mzapi_hash_node *)0))
    {
     s_this = (struct ts_shadow *)s_hash_node->vector; 
     if(strcmp(s_passwd->pw_name, s_this->namp) == 0)break;
     s_hash_node = s_shadow_hash->next_search(s_shadow_hash, s_hash_node);
    }
    if(s_hash_node == ((struct ts_mzapi_hash_node *)0))continue;
    if(strcmp(s_this->pwdp, s_this->crypt) != 0)continue;
    (void)fprintf(stdout, "warning: \x1b[1;31m%s\x1b[0m (%s) account detected\n", s_passwd->pw_name, s_passwd->pw_dir);
   }while(1);
   endpwent();
   s_shadow = free_shadow(s_shadow);
  }
  else (void)fprintf(stdout, "error: shadow\n");
  s_shadow_hash = mzapi_close_hash(s_shadow_hash);
 }
 else (void)fprintf(stdout, "error: hash\n");
 return(0);
}

/* vim: set expandtab: */
/* End of source */
