/*
  Copyright (C) JAEHYUK CHO
  All rights reserved.
  Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <shadow.h>
#include <unistd.h>
#include <crypt.h>

#define def_pwentry_debug (1)

int main(void)
{
 struct passwd *s_password_entry;
 struct spwd *s_shadow_entry; 
 size_t s_pwdp_size;
 char s_salt[13];
 const char *s_crypt;
 setpwent();
 do
 {
  s_password_entry = getpwent();
  if(s_password_entry == ((struct passwd *)0))break;
#if def_pwentry_debug != (0) /* DEBUG */
  (void)fprintf(stdout,
   "name=\"%s\", passwd=\"%s\", uid=%u, gid=%u, gecos=\"%s\", dir=\"%s\", shell=\"%s\"\n",
   s_password_entry->pw_name, s_password_entry->pw_passwd, (unsigned int)s_password_entry->pw_uid, (unsigned int)s_password_entry->pw_gid, s_password_entry->pw_gecos, s_password_entry->pw_dir, s_password_entry->pw_shell
  );
#endif
  setspent();
  do
  {
   s_shadow_entry = getspent();
   if(s_shadow_entry == ((struct spwd *)0))break;
   if(strcmp(s_password_entry->pw_name, s_shadow_entry->sp_namp) == 0)
   {
    s_pwdp_size = strlen(s_shadow_entry->sp_pwdp);
    s_salt[0] = '\0';
    if(s_pwdp_size > ((size_t)0))
    {
     if(s_shadow_entry->sp_pwdp[0] == '$')
     {
      if((s_pwdp_size > ((size_t)12)) && (s_shadow_entry->sp_pwdp[2] == '$') && (s_shadow_entry->sp_pwdp[11] == '$')) 
      {
       (void)memcpy((void *)(&s_salt[0]), (void *)(&s_shadow_entry->sp_pwdp[0]), (size_t)12);
       s_salt[12] = '\0';
      }
     }
     else if(s_pwdp_size > ((size_t)2))
     {
      (void)memcpy((void *)(&s_salt[0]), (void *)(&s_shadow_entry->sp_pwdp[0]), (size_t)2);
      s_salt[2] = '\0';
     }
    }
    s_crypt = crypt(s_shadow_entry->sp_namp, (char *)(&s_salt[0]));
#if def_pwentry_debug != (0) /* DEBUG */
    (void)fprintf(stdout,
     "\tpwdp=\"%s\", lstchg/min/max/warn/inact/expire/flag=%ld/%ld/%ld/%ld/%ld/%ld/%08lXH\n\tcrypt=\"%s\"\n",
     s_shadow_entry->sp_pwdp, (long)s_shadow_entry->sp_lstchg, (long)s_shadow_entry->sp_min, (long)s_shadow_entry->sp_max, (long)s_shadow_entry->sp_warn, (long)s_shadow_entry->sp_inact, (long)s_shadow_entry->sp_expire, (unsigned long)s_shadow_entry->sp_flag, s_crypt);
#else
    if(strcmp(s_shadow_entry->sp_pwdp, s_crypt) == 0)(void)fprintf(stdout, "%s (%s) account detected\n", s_password_entry->pw_name, s_password_entry->pw_dir);
#endif
    break;
   }
  }while(1);
  endspent();
  (void)fflush(stdout);
 }while(1);
 endpwent();
 (void)memset((void *)(&s_salt[0]), 0, sizeof(s_salt));
 return(0);
}

/* vim: set expandtab: */
/* End of source */
