/*
 [ GPL ]

 Code by JaeHyuk Cho <minzkn@infoeq.co.kr> 
*/

#if !defined(DEF_mp3_ext_h)
#define DEF_mp3_ext_h "mp3_ext.h"

#define DEF_MP3_FRAMESYNC               (0xffe00000lu)

#define DEF_MP3_STEREO                  (0x00)
#define DEF_MP3_JOINT_STEREO            (0x01)
#define DEF_MP3_DUAL_CHANNEL            (0x02)
#define DEF_MP3_SINGLE_CHANNEL          (0x03)

typedef struct ts_MZ_BufferNode 
{
 struct ts_MZ_BufferNode *Next;
 unsigned long        Current;
 unsigned long        Size;
 void                *Data; 
}t_MZ_BufferNode;

typedef struct ts_MZ_Buffer
{
 unsigned long        Total;
 void                *Align;
 int                  AlignIndex; 
 t_MZ_BufferNode     *Head;   
}t_MZ_Buffer;

typedef unsigned long                   t_MP3_Header;

typedef struct ts_MP3_Frame
{
 struct ts_MP3_Frame                   *Next;
 unsigned long                          Header;

 unsigned long                          Version        : 2;
 unsigned long                          Layer          : 2;
 unsigned long                          Protection     : 1;
 unsigned long                          BitrateIndex   : 4;
 unsigned long                          FrequencyIndex : 2;
 unsigned long                          Padding        : 1;
 unsigned long                          FreeBit        : 1;
 unsigned long                          ChannelMode    : 2;
 unsigned long                          ModeExtension  : 2;
 unsigned long                          Copyright      : 1;
 unsigned long                          Original       : 1;
 unsigned long                          Emphasis       : 2;
 
 unsigned long                          FrameSize;
 void                                  *Frame; 
 unsigned long                          DecodeSize;
 void                                  *Decode;
}t_MP3_Frame;

typedef struct ts_MP3
{
 t_MP3_Frame                           *EncodeBuffer;
 t_MP3_Frame                           *ChargeFrame;
 t_MZ_Buffer                           *ChargeBuffer;
 t_MP3_Header                           Header;
 unsigned long                          DecodeLevel;
 unsigned long                          FrameCount;
 unsigned long                          PlayTime;
 char                                  *Title;
 char                                  *Artist;
 char                                  *Album;
 char                                  *Year;
 char                                  *Comment;
 char                                  *Genre;
 int                                    IsID3;
}t_MP3;

#if defined(DEF_mp3_ext_c)

#else

#if defined(__cplusplus)
extern "C"{
#endif

extern t_MP3 *MZ_CreateMP3(void);
extern t_MP3 *MZ_DestroyMP3(t_MP3 *s_MP3);
extern t_MP3 *MZ_PushMP3(t_MP3 *s_MP3, void *s_Buffer, int s_Size);

extern unsigned long MZ_MP3_FileTime(char *s_MP3_Name);

extern void MZ_MP3_DecoderOpen(void);
extern void MZ_MP3_DecoderClose(void);
extern int MZ_MP3_DecoderPush(void *s_Buffer, int s_Length);
extern int MZ_MP3_DecoderPop(void *s_Buffer, int s_Length);
extern int MZ_MP3_DecoderFrequency(void);
extern int MZ_MP3_DecoderCheckBuffer(void);

extern void *MZ_Alloc(int s_Length);
extern void MZ_Free(void *s_Memory);
extern t_MZ_Buffer *MZ_PushBuffer(t_MZ_Buffer *s_HANDLE_Buffer, void *s_Data, unsigned long s_Length);
extern unsigned long MZ_PopBuffer(t_MZ_Buffer *s_HANDLE_Buffer, void *s_Data, unsigned long s_Length);
extern t_MZ_Buffer *MZ_DestroyBuffer(t_MZ_Buffer *s_HANDLE_Buffer);
extern unsigned long MZ_CheckBuffer(t_MZ_Buffer *s_HANDLE_Buffer);

#if defined(__cplusplus)
}
#endif

#endif

#endif

/* End of source */
