/* 
  Revision by JaeHyuk Cho <mailto:minzkn@infoeq.com>
*/   


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <errno.h>
#include <string.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/resource.h>

#include "mpg123.h"

real decwin[512+32];
static real cos64[16],cos32[8],cos16[4],cos8[2],cos4[1];
real *pnts[] = { cos64,cos32,cos16,cos8,cos4 };

static long intwinbase[] = {
     0,    -1,    -1,    -1,    -1,    -1,    -1,    -2,    -2,    -2,
    -2,    -3,    -3,    -4,    -4,    -5,    -5,    -6,    -7,    -7,
    -8,    -9,   -10,   -11,   -13,   -14,   -16,   -17,   -19,   -21,
   -24,   -26,   -29,   -31,   -35,   -38,   -41,   -45,   -49,   -53,
   -58,   -63,   -68,   -73,   -79,   -85,   -91,   -97,  -104,  -111,
  -117,  -125,  -132,  -139,  -147,  -154,  -161,  -169,  -176,  -183,
  -190,  -196,  -202,  -208,  -213,  -218,  -222,  -225,  -227,  -228,
  -228,  -227,  -224,  -221,  -215,  -208,  -200,  -189,  -177,  -163,
  -146,  -127,  -106,   -83,   -57,   -29,     2,    36,    72,   111,
   153,   197,   244,   294,   347,   401,   459,   519,   581,   645,
   711,   779,   848,   919,   991,  1064,  1137,  1210,  1283,  1356,
  1428,  1498,  1567,  1634,  1698,  1759,  1817,  1870,  1919,  1962,
  2001,  2032,  2057,  2075,  2085,  2087,  2080,  2063,  2037,  2000,
  1952,  1893,  1822,  1739,  1644,  1535,  1414,  1280,  1131,   970,
   794,   605,   402,   185,   -45,  -288,  -545,  -814, -1095, -1388,
 -1692, -2006, -2330, -2663, -3004, -3351, -3705, -4063, -4425, -4788,
 -5153, -5517, -5879, -6237, -6589, -6935, -7271, -7597, -7910, -8209,
 -8491, -8755, -8998, -9219, -9416, -9585, -9727, -9838, -9916, -9959,
 -9966, -9935, -9863, -9750, -9592, -9389, -9139, -8840, -8492, -8092,
 -7640, -7134, -6574, -5959, -5288, -4561, -3776, -2935, -2037, -1082,
   -70,   998,  2122,  3300,  4533,  5818,  7154,  8540,  9975, 11455,
 12980, 14548, 16155, 17799, 19478, 21189, 22929, 24694, 26482, 28289,
 30112, 31947, 33791, 35640, 37489, 39336, 41176, 43006, 44821, 46617,
 48390, 50137, 51853, 53534, 55178, 56778, 58333, 59838, 61289, 62684,
 64019, 65290, 66494, 67629, 68692, 69679, 70590, 71420, 72169, 72835,
 73415, 73908, 74313, 74630, 74856, 74992, 75038 
};

static int tabsel_123[2][3][16] = {
            { {0,32,64,96,128,160,192,224,256,288,320,352,384,416,448,},
              {0,32,48,56, 64, 80, 96,112,128,160,192,224,256,320,384,},
              {0,32,40,48, 56, 64, 80, 96,112,128,160,192,224,256,320,} 
            },
            { {0,32,48,56,64,80,96,112,128,144,160,176,192,224,256,},
              {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,},
              {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,} }
           };

long g_Frequency[9] = {44100, 48000, 32000, 22050, 24000, 16000 , 11025 , 12000 , 8000};

#if defined(DEF_I386)
int synth_1to1_mono(real *bandPtr,unsigned char *samples,int *pnt);
int synth_1to1(real *bandPtr,int channel,unsigned char *out,int *pnt);
#endif
int InitMP3(struct mpstr *mp);
void ExitMP3(struct mpstr *mp);
int decodeMP3(struct mpstr *mp,char *inmemory,int inmemsize, char *outmemory,int *done);

struct mpstr *gmp = (struct mpstr *)0;

#if defined(DEF_I386)
int synth_1to1_mono(real *bandPtr,unsigned char *samples,int *pnt)
{
 int i,ret;
 ret = synth_1to1(bandPtr,0,samples,pnt);
 samples = samples + *pnt - 128;
 for(i=0;i<32;i++) 
 {
  ((short *)samples)[1] = ((short *)samples)[0];
  samples+=4;
 }
 return ret;
}

int synth_1to1(real *bandPtr,int channel,unsigned char *out,int *pnt)
{
 int ret;
 ret = synth_1to1_pent(bandPtr,channel,out+*pnt);
 *pnt += 128;
 return ret;
}
#endif

static int decode_header(struct frame *fr,unsigned long newhead)
{
 if( newhead & (1<<20) ) /* Version 2.0 and 1.0 */
 {
  fr->lsf = (newhead & (1<<19)) ? 0x0 /* Version 1.0 */ : 0x1 /* Version 2.0 */;
  fr->mpeg25 = 0;
 }
 else fr->lsf = fr->mpeg25 = 1; /* Version 2.5 */
 fr->lay = 4 - ((newhead >> 17) & 3);
 if(fr->mpeg25)fr->sampling_frequency = 6 + ((newhead>>10)&0x3);
 else fr->sampling_frequency = ((newhead>>10)&0x3) + (fr->lsf*3);
 fr->error_protection = ((newhead >> 16) & 0x1) ^ 0x1;
 fr->bitrate_index    = ((newhead >> 12) & 0xf);
 fr->padding          = ((newhead >>  9) & 0x1);
 fr->extension        = ((newhead >>  8) & 0x1);
 fr->mode             = ((newhead >>  6) & 0x3);
 fr->mode_ext         = ((newhead >>  4) & 0x3);
 fr->stereo           = (fr->mode == MPG_MD_MONO) ? 1 : 2;
 switch(fr->lay) 
 {
  case 3:
       fr->do_layer_b = do_layer3_b;
       fr->framesize  = (long)tabsel_123[fr->lsf][2][fr->bitrate_index] * 144000l;
       fr->framesize /= g_Frequency[fr->sampling_frequency]<<(fr->lsf);
       fr->framesize  = fr->framesize + fr->padding - 4;
       return(1);; 
  case 2:
       fr->do_layer_b = NULL;
       /* fprintf(stderr, "common.c: decode_header - [ERROR] Not support layer 2 !!!\n");  */
       return(0);
  case 1:
       fr->do_layer_b = NULL;
       /* fprintf(stderr, "common.c: decode_header - [ERROR] Not support layer 1 !!!\n");  */
       return(0);
  default:
       fr->do_layer_b = NULL;
       fprintf(stderr,"common.c: decode_header - [ERROR] Sorry, unknown layer type !!!\n"); 
       return(0);
 }
}


static void make_decode_tables(long scaleval)
{
 int i,j,k,kr,divv;
 real *costab;
 int idx;
 for(i=0;i<5;i++)
 {
  kr=0x10>>i; divv=0x40>>i;
  costab = pnts[i];
  for(k=0;k<kr;k++)
      costab[k] = DOUBLE_TO_REAL(1.0 / (2.0 * cos(M_PI * ((double) k * 2.0 + 1.0) / (double) divv)));
 }
 idx = 0;
 scaleval = -scaleval;
 for(i=0,j=0;i<256;i++,j++,idx+=32)
 {
  if(idx < 512+16)
      decwin[idx+16] = decwin[idx] = DOUBLE_TO_REAL((double) intwinbase[j] / 65536.0 * (double) scaleval);
  if(i % 32 == 31)
	  idx -= 1023;
  if(i % 64 == 63)
	  scaleval = - scaleval;
 }
 for( /* i=256 */ ;i<512;i++,j--,idx+=32)
 {
  if(idx < 512+16)
      decwin[idx+16] = decwin[idx] = DOUBLE_TO_REAL((double) intwinbase[j] / 65536.0 * (double) scaleval);
  if(i % 32 == 31)
	  idx -= 1023;
  if(i % 64 == 63)
	  scaleval = - scaleval;
 }
}


int InitMP3(struct mpstr *mp) 
{
 memset(mp, 0, sizeof(struct mpstr));
 initbitloader((unsigned char *)0, 0);
 gmp           = (struct mpstr *)0;
 mp->framesize = 0;
 mp->fsizeold  = 0;
 mp->fr.single = -1;
 mp->bsnum     = 0;
 mp->SkipByte  = 0;
 make_decode_tables(32 << 10);
 init_layer3(SBLIMIT);
 return !0;
}

void ExitMP3(struct mpstr *mp)
{
 if(mp)
 {
  if(mp->Buffer)mp->Buffer = MZ_DestroyBuffer(mp->Buffer);
 }
}

int decodeMP3(struct mpstr *mp,char *in,int isize,char *out, int *done)
{
 const unsigned long c_Tag = ( ((unsigned long)('T') << 16) | ((unsigned long)('A') << 8) | ((unsigned long)('G')) );
 int s_Return = MP3_OK;
 unsigned char *s_TempWordPointer;
 *done = 0;
 gmp = mp;
 if(in) 
 {
  if(isize > 0)mp->Buffer = MZ_PushBuffer(mp->Buffer, in, isize);
  if(mp->Buffer == (t_MZ_Buffer *)0)
  {
   /* fprintf(stderr,"interface.c: decodeMP3 - [ERROR] Add buffer failed !!!\n"); */
   return MP3_ERR;
  }
 }
 /*if(mp->SkipByte > 0)
 {*/
  /* BUGFIX : Add L_TAG_ADD label */
  L_TAG_ADD:;
  while(mp->SkipByte > 0)
  {
   if(MZ_CheckBuffer(mp->Buffer) < 1)return(MP3_NEED_MORE);
   MZ_PopBuffer(mp->Buffer, &mp->TAG[128 - mp->SkipByte], 1);
   mp->SkipByte--;  
  }
 /*} */
 if(mp->framesize == 0)
 {
  int s_Count = 0; 
  unsigned char s_Byte;
  while(
         ( ( mp->header &  0xffe00000) != 0xffe00000) ||
         ( ((mp->header >> 19) & 0x03) == 0x01   )    || 
         ( ((mp->header >> 17) & 0x03) == 0x00   )    || 
         ( ((mp->header >> 12) & 0x0f) == 0x0f   )    || 
         ( ((mp->header >> 12) & 0x0f) == 0x00   )    ||
         ( ((mp->header >> 10) & 0x03) == 0x03   ) 
        )
  {
   if(c_Tag == (mp->header & 0x00ffffff))
   {
    mp->SkipByte = 128 - 3;
    mp->framesize = 0;	  
    mp->header = 0lu;
    /* BUGFIX: return(MP3_NEED_MORE) delete -> Add goto L_TAG_ADD */
    goto L_TAG_ADD;
   }	   
   if(MZ_CheckBuffer(mp->Buffer) < 1)
   {
    mp->framesize = 0;	  
    return(MP3_NEED_MORE);
   }
   MZ_PopBuffer(mp->Buffer, &s_Byte, 1); 
   mp->header = (mp->header << 8) | ((unsigned long)s_Byte & 0xff);
   s_Count++;
  }
  decode_header(&mp->fr,mp->header);
  mp->framesize = mp->fr.framesize;
 }
 if(mp->fr.framesize > MZ_CheckBuffer(mp->Buffer))
 {
  mp->fr.framesize = 0;	 
  return MP3_NEED_MORE;
 }
 mp->header = 0lu;	
 s_TempWordPointer = mp->bsspace[mp->bsnum] + 512;
 initbitloader(s_TempWordPointer, 0);
 mp->bsnum = (mp->bsnum + 1) & 0x1;
 if(mp->framesize > 0)MZ_PopBuffer(mp->Buffer, s_TempWordPointer, mp->framesize);
 if(mp->fr.error_protection)getbits(16);
 if(mp->fr.do_layer_b)
 {
  mp->fr.do_layer_b(&mp->fr,(unsigned char *)out,done);
  if(*done == 0)s_Return = MP3_NEED_MORE;
 }
 mp->fsizeold = mp->framesize;
 mp->framesize = 0;
 return s_Return;
}

/* End of source */

