/*
 JaeHyuk's MP3 library example <mailto:minzkn@infoeq.com>
TODO: Mixer
*/

#include <stdio.h>

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>

#include <linux/soundcard.h>

#include <pthread.h>

#include "mpg123.h"
#include "mp3_ext.h"

/* ⺻ ۸ ũ 2MByte  ̽  Ǵ CPU ɿ  ؾ ϴ 쵵 ֽϴ.  κ ״ ϼŵ   ̴ϴ. DEF_BUFFER_WIDTH ߰  32KByte ũ⸦ ߰ ۸Ҽ ֽϴ. */
#define DEF_BUFFER_WIDTH ( 2 << 20 )

typedef struct ts_pmp3_ctrl
{
 int ThreadControl, Frequency, IsWait; 
 int PushSize, FileSize, DecodePushSize, DecodePopSize;
}t_pmp3_ctrl;

typedef struct ts_pmp3_list
{
 struct ts_pmp3_list *Next;
 char                *Name;
 int                  Touch;
}t_pmp3_list;

static int g_Ctrl_C = 0;

static void MZ_Ctrl_C(int s_Signal)
{
 /* Ctrl + C  Signal ؼ ȴٰ ǥմϴ. */
 g_Ctrl_C = 1;
 if(s_Signal == SIGSEGV)exit(0);
}

static int MZ_SetupDSP(int s_Handle, int s_Channels, int s_Freq)
{
 int s_Format = AFMT_S16_NE;
 /* DSP ø  16Ʈ 2ä ׷  : MP3 decoder   MP3 PCM ٲٸ鼭 16Ʈ ȯ ֹǷ   Դϴ. */
 if(ioctl(s_Handle, SNDCTL_DSP_SETFMT, &s_Format) == 0)
 {
  if(ioctl(s_Handle, SNDCTL_DSP_CHANNELS, &s_Channels) == 0)
  {
   if(ioctl(s_Handle, SNDCTL_DSP_SPEED, &s_Freq) == 0)
   {
    return(1);
   }
  }
 }
 return(-1);
}

static void *MZ_ThreadDecoder(void *s_Argument)
{ 
 t_pmp3_ctrl *s_Control = (t_pmp3_ctrl *)s_Argument;
 int s_Handle, s_PopSize, s_CurrentFrequency;
 
 /* Ư ̽    ũ 8KByteϷ ؾ  û밡  쵵  ڽ machine Ҹ ϶  迭 ũ⸦ 8KByte Ϸ  ñ ٶϴ. */
 unsigned char s_Buffer[ 32 << 10 ]; 
 
 /* DSP  ϴ. ̽  ̰    κ ϳ Instance µ Դϴ. */
 s_Handle = open("/dev/dsp", O_RDWR);
 if(s_Handle >= 0)
 {
  /* ʱ ļ 0 صӴϴ. */
  s_Control->Frequency = 0;
  s_Control->ThreadControl = 2; /* Thread  ʱȭ Ǿٴ  ǥմϴ. */
  while(s_Control->ThreadControl != 0)
  {
   /* Decode ۿ Decode PCMͰ  0 ū  ȯմϴ. */
   s_PopSize = MZ_MP3_DecoderPop(s_Buffer, sizeof(s_Buffer));
   if(s_PopSize > 0)
   {
    s_Control->IsWait = 0;
    s_Control->DecodePopSize += s_PopSize;
    /*  Decode  ø ļ MP3 RAW header ϴ. */
    s_CurrentFrequency = MZ_MP3_DecoderFrequency();
    if(s_CurrentFrequency > 0) 
    {
     if(s_Control->Frequency != s_CurrentFrequency)
     {
      /* ø ļ µ dsp մϴ. */
      if(MZ_SetupDSP(s_Handle, 2, s_CurrentFrequency) > 0)s_Control->Frequency = s_CurrentFrequency;		 
      else 
      {
       fprintf(stderr, "Can not setup DSP !\n");
       break;
      }
     }
    }
#if 1 /* 0=Skip DSP, 1=DSP write*/
    /* dsp  ֽϴ. ̶ ø  16Ʈ ׷ 2ä ŸԴϴ. */
    if(s_Control->Frequency > 0)write(s_Handle, s_Buffer, s_PopSize);  /* DSP Write (PLAY PCM) */
#elif 1 /*   */
    if(s_Control->Frequency > 0)
    { /* Eq. BASS */
     int s_Index;
     signed short *s_SamplePtr;
     signed short s_Sample;
     for(s_Index = 0;s_Index < s_PopSize;s_Index += 2)
     {
      s_SamplePtr = (signed short *)(&s_Buffer[s_Index]);
      s_Sample = (signed short)( *(s_SamplePtr) );
      s_Sample = s_Sample * 1; 
      *(s_SamplePtr) = s_Sample;
     }
     write(s_Handle, s_Buffer, s_PopSize);  /* DSP Write (PLAY PCM) */
    }
#endif
   }
   else 
   { /* ۰ ٸ 1ʸ ϴ. */
    s_Control->IsWait = 1;
    sleep(1); 
   }
  }
  close(s_Handle);
 }
 else perror("Can not open /dev/dsp");
 s_Control->ThreadControl = (-1); /* ThreadḦ ǥմϴ. */
 return(s_Argument);
}

static t_pmp3_list *MZ_pmp3_listup(t_pmp3_list *s_List, const char *s_Name, int *s_ListCount)
{
 DIR *s_Directory;
 struct dirent *s_DirectoryEntry;
 struct stat s_Stat;
 char *s_FullPath;
 t_pmp3_list *s_TraceList, *s_LastList;
 if(s_Name)
 {
  if(stat(s_Name, &s_Stat) == 0)
  { /* ¸    ۹̼    Ʈ ߰ ʽϴ. */
   if(S_ISDIR(s_Stat.st_mode))
   { /*  丮    ˻Ͽ ߰մϴ. */
    fprintf(stdout, "Scanning directory: \"%s\"\n", s_Name);
    s_Directory = opendir(s_Name);
    if(s_Directory)
    {
     do
     {
      s_DirectoryEntry = readdir(s_Directory);
      if(s_DirectoryEntry)
      {
       if(strcmp(s_DirectoryEntry->d_name, ".") != 0 && strcmp(s_DirectoryEntry->d_name, "..") != 0) 
       {
        s_FullPath = (char *)malloc(strlen(s_Name) + 1 + strlen(s_DirectoryEntry->d_name) + 1);             
        if(s_FullPath)
        {
         sprintf(s_FullPath, "%s%s%s", s_Name, *(s_Name + strlen(s_Name) - 1) == '/' ? "" : "/", s_DirectoryEntry->d_name);
         s_List = MZ_pmp3_listup(s_List, s_FullPath, s_ListCount); /*  ˻ */
         free(s_FullPath);
        }
       }
      }
     }while(s_DirectoryEntry);
     closedir(s_Directory); 
    }
   }
   else if(S_ISREG(s_Stat.st_mode) || S_ISLNK(s_Stat.st_mode))
   { /* Ϲ ̰ų ũ  Ʈ ߰մϴ. */
    s_LastList = s_TraceList = s_List;
    while(s_TraceList)
    {
     if(strcmp(s_Name, s_TraceList->Name) == 0)break;
     if(s_TraceList->Next == (t_pmp3_list *)0)s_LastList = s_TraceList;
     s_TraceList = s_TraceList->Next;
    }
    if(s_TraceList == (t_pmp3_list *)0)
    {
     s_TraceList = (t_pmp3_list *)malloc(sizeof(t_pmp3_list));
     if(s_TraceList)
     {
      s_TraceList->Next = (t_pmp3_list *)0;
      s_TraceList->Name = (char *)malloc(strlen(s_Name) + 1); 
      s_TraceList->Touch = 0;
      if(s_TraceList->Name)strcpy(s_TraceList->Name, s_Name);
      if(s_LastList)s_LastList->Next = s_TraceList;
      else s_List = s_TraceList;
      if(s_ListCount)(*s_ListCount)++;
     } 
    }
   }
  }
 }
 return(s_List);
}

/* Play ¸ ǥմϴ. : ̹ۿ   ǥҼ  ȭ ˳ġ   ... */
static void MZ_MP3_StatusPrint(t_pmp3_ctrl *s_Control)
{
 fprintf(stdout, "\r DecodeBuffer=%.2f%%, File=%d/%d(%.2f%%), CL=%.2f:1, %dHz ", 
/*         s_Control->DecodePopSize, s_Control->DecodePushSize, 
         (float)s_Control->DecodePopSize * 100.0 / (float)s_Control->DecodePushSize,*/
         (float)(s_Control->DecodePushSize - s_Control->DecodePopSize) * 100.0 / (float)DEF_BUFFER_WIDTH,
         s_Control->PushSize, s_Control->FileSize,
         (float)s_Control->PushSize * 100.0 / (float)s_Control->FileSize,
         (float)s_Control->DecodePushSize / (float)s_Control->PushSize, 
         s_Control->Frequency);
 fflush(stdout);
}

static void MZ_pmp3_listmix(t_pmp3_list *s_List, int s_ListCount)
{ /*  Ƿ ϴ. */
 int s_Index, s_SwapIndex;
 t_pmp3_list *s_LeftTrace, *s_RightTrace;
 char *s_TempName;
 fprintf(stdout, "Play list mixing. . .\n");
 srand(time((time_t *)0));
 s_LeftTrace = s_List;
 while(s_LeftTrace)
 {
  if(s_LeftTrace->Touch == 0)
  {
   s_SwapIndex = rand() % s_ListCount;
   s_Index = 0, s_RightTrace = s_List;
   while(s_RightTrace)
   {
    if(s_Index++ == s_SwapIndex)
    {
     s_RightTrace->Touch = 1;
     s_LeftTrace->Touch = 1;
     s_TempName = s_LeftTrace->Name;
     s_LeftTrace->Name = s_RightTrace->Name;
     s_RightTrace->Name = s_TempName;
     break;
    }
    s_RightTrace = s_RightTrace->Next;
   }
  }
  s_LeftTrace = s_LeftTrace->Next;
 }
 s_LeftTrace = s_List;
 while(s_LeftTrace)
 {
  s_LeftTrace->Touch = 0;
  s_LeftTrace = s_LeftTrace->Next;
 }
}

int main(int s_Argc, char *s_Argv[])
{
 int s_Return = 0, s_ArgCount, s_Handle, s_ReadBytes, s_ListCount;
 unsigned char s_Buffer[ 32 << 10 ]; 
 pthread_t s_Thread;
 t_MP3 *s_MP3;
 t_pmp3_list *s_List, *s_TraceList;
 t_pmp3_ctrl s_Control;
 
 fprintf(stdout, "pmp3 release 0.0.9 - Code by JaeHyuk Cho <mailto:minzkn@infoeq.com>\nBuild - %s %s\n\n", __DATE__, __TIME__);
 
 /* Play list ˻մϴ.  丮  ˻Ͽ Ʈ ߰մϴ. */
 for(s_List = (t_pmp3_list *)0, s_ArgCount = 1, s_ListCount = 0;s_ArgCount < s_Argc;s_ArgCount++)
 {
  s_List = MZ_pmp3_listup(s_List, s_Argv[s_ArgCount], &s_ListCount);
 }

 fprintf(stdout, "Total play list : %d\n", s_ListCount);

 if(s_List)
 {
  /* Decoder engine ʿ ޸𸮸 Ҵմϴ. */
  MZ_MP3_DecoderOpen();

  /* Decode  PCM͸  /dev/dsp ־ִ Thread մϴ.  Decode ۸  ̴  Pop ϸ鼭 Decodeϸ   CPU    ߻մϴ.  ̸ Pushۿ DeocdeѰ  ̵   ʿմϴ. */
  s_Control.ThreadControl = 1;
  if(pthread_create(&s_Thread, NULL, MZ_ThreadDecoder, (void *)(&s_Control)) != 0)s_Control.ThreadControl = (-1);
  while(s_Control.ThreadControl == 1)sleep(1);
  
  if(s_Control.ThreadControl == 2)
  {

   /*  ñ׳ ŵϴ. : Ctrl + C     ó մϴ. */
   signal(SIGSEGV, MZ_Ctrl_C);
   signal(SIGABRT, MZ_Ctrl_C);
   signal(SIGTERM, MZ_Ctrl_C);
   signal(SIGQUIT, MZ_Ctrl_C);
   signal(SIGHUP, MZ_Ctrl_C);
   signal(SIGINT, MZ_Ctrl_C);
 
   
L_ReTry:;
   /*  ִ κ */
   if(s_List && s_ListCount >= 2)MZ_pmp3_listmix(s_List, s_ListCount);
   
   s_TraceList = s_List;
   while(s_TraceList && g_Ctrl_C == 0)
   {
    s_Control.PushSize = s_Control.DecodePushSize = s_Control.DecodePopSize = 0;

    /*  ϴ. */
    s_Handle = open(s_TraceList->Name, O_RDONLY);
    if(s_Handle != (-1))
    {
     fprintf(stdout, "Buffering \"%s\"\n", s_TraceList->Name);
     
     /* MP3  ϱ ؼ  κа ùκ ˻մϴ. */
     s_MP3 = MZ_CreateMP3();
     if(s_MP3)
     {
      s_Control.FileSize = (int)lseek(s_Handle, -(sizeof(s_Buffer)), SEEK_END); /* Ųٷ~ о  ID3 ã ؼ */
      s_ReadBytes = read(s_Handle, &s_Buffer[0], sizeof(s_Buffer));
      if(s_ReadBytes > 0)
      {
       s_Control.FileSize += s_ReadBytes;
       s_MP3 = MZ_PushMP3(s_MP3, &s_Buffer[0], s_ReadBytes);
      }
      if(s_MP3->IsID3 == 0)
      {
       lseek(s_Handle, 0, SEEK_END); /* Ųٷ о ID3 ã ϸ պκ ˻ */
       s_ReadBytes = read(s_Handle, &s_Buffer[0], sizeof(s_Buffer));
       if(s_ReadBytes > 0)s_MP3 = MZ_PushMP3(s_MP3, &s_Buffer[0], s_ReadBytes);
       if(s_MP3->IsID3 == 0)fprintf(stdout, "Not found ID3.\n");
      }
      if(s_MP3->IsID3 == 1)
      {
       if(s_MP3->Title  )fprintf(stdout, " Title    : \"%s\"\n", s_MP3->Title);
       if(s_MP3->Artist )fprintf(stdout, " Artist   : \"%s\"\n", s_MP3->Artist);
       if(s_MP3->Album  )fprintf(stdout, " Album    : \"%s\"\n", s_MP3->Album);
       if(s_MP3->Year   )fprintf(stdout, " Year     : \"%s\"\n", s_MP3->Year);
       if(s_MP3->Comment)fprintf(stdout, " Comment  : \"%s\"\n", s_MP3->Comment);
       if(s_MP3->Genre  )fprintf(stdout, " Genre    : \"%s\"\n", s_MP3->Genre);
       /* fprintf(stdout, " Play time: %02lu:%02lu:%02lu\n", 
                  s_MP3->PlayTime / 3600, 
                  (s_MP3->PlayTime / 60) % 60,
                  s_MP3->PlayTime % 60); - MP3 ó  о ȿ  ˴ϴ. */
      }
      s_MP3 = MZ_DestroyMP3(s_MP3);
      lseek(s_Handle, 0, SEEK_SET);
     }

     /* Decode ۿ MP3 RAW͸ ״  ֽϴ. ̶ MZ_MP3_DecoderPush ̸ ޾Ƽ 1ۿ 鼭 Decode۾ մϴ. */ 
     do
     {
      if(MZ_MP3_DecoderCheckBuffer() < DEF_BUFFER_WIDTH) /* Buffer width */
      {
       s_ReadBytes = read(s_Handle, &s_Buffer[0], sizeof(s_Buffer));
       if(s_ReadBytes >= 0)
       {
        s_Control.DecodePushSize += MZ_MP3_DecoderPush(&s_Buffer[0], s_ReadBytes);
        s_Control.PushSize += s_ReadBytes;
       }  
      }
      else sleep(1), s_ReadBytes = sizeof(s_Buffer);
      MZ_MP3_StatusPrint(&s_Control);
     }while(s_ReadBytes == sizeof(s_Buffer) && g_Ctrl_C == 0);

     close(s_Handle);

     /* ۰ ɶ մϴ. ϴ   MP3 ٷ  MP3 sampling ļ ٸ "ߺ" ϴ Ҹ ߻մϴ.   ļ ø ̶ ø ˴ϴ. */
     while(MZ_MP3_DecoderCheckBuffer() > 0 && g_Ctrl_C == 0)
     {
      MZ_MP3_StatusPrint(&s_Control);
      sleep(1); 
     }
     MZ_MP3_StatusPrint(&s_Control);
     fprintf(stdout, "\n");
    }
    else 
    {
     fprintf(stderr, "Can not open file \"%s\" !\n", s_TraceList->Name);
     sleep(1);
    }
    s_TraceList = s_TraceList->Next;
   }
   if(g_Ctrl_C == 0)goto L_ReTry; 
  }
  else fprintf(stdout, "Thread failed ! (%d)\n", s_Control.ThreadControl);
  fprintf(stdout, "Exiting... (%d)\n", g_Ctrl_C);
  s_Control.ThreadControl = 0;
  
  /* Thread ɶ մϴ. */
  pthread_join(s_Thread, (void **)0);

  /* Decode engine մϴ. : ׳ ޸  */ 
  MZ_MP3_DecoderClose();

  /* Play list ޸𸮿 մϴ. */
  while(s_List)
  {
   s_TraceList = s_List;
   s_List = s_List->Next;
   if(s_TraceList->Name)free(s_TraceList->Name);
   free(s_TraceList);
  }
  fprintf(stdout, "End of pmp3.\n");
 }
 else fprintf(stderr, "Usage: %s [<Mp3 file | Directory> ...]\n", s_Argv[0]);
 return(s_Return);
}

/* End of source */
