/*
 Revision by JaeHyuk Cho <mailto:minzkn@infoeq.com>
*/   

#include "mpg123.h"

static unsigned char *wordpointer = (unsigned char *)0;
static int bitindex = 0;

void initbitloader(unsigned char *s_WordPointer, int s_BitIndex)
{
 wordpointer = s_WordPointer;	
 bitindex = s_BitIndex;
}

unsigned char *getbitloader(void)
{
 return(wordpointer);
}

void backbits(int number_of_bits)
{
  bitindex    -= number_of_bits;
  wordpointer += (bitindex>>3);
  bitindex    &= 0x7;
}

int getbitoffset(void) 
{
  return (-bitindex)&0x7;
}

int getbyte(void)
{
  return *wordpointer++;
}

unsigned int getbits(int number_of_bits)
{
  unsigned long rval;
  if(!number_of_bits)return 0;
  {
    rval = wordpointer[0];
    rval <<= 8;
    rval |= wordpointer[1];
    rval <<= 8;
    rval |= wordpointer[2];
    rval <<= bitindex;
    rval &= 0xffffff;
    bitindex += number_of_bits;
    rval >>= (24-number_of_bits);
    wordpointer += (bitindex>>3);
    bitindex &= 7;
  }
  return rval;
}

unsigned int getbits_fast(int number_of_bits)
{
  unsigned int rval;
  rval =  (unsigned char) (wordpointer[0] << bitindex);
  rval |= ((unsigned int) wordpointer[1]<<bitindex)>>8;
  rval <<= number_of_bits;
  rval >>= 8;
  bitindex += number_of_bits;
  wordpointer += (bitindex>>3);
  bitindex &= 7;
  return rval;
}

unsigned int get1bit(void)
{
  unsigned char rval;
  rval = *wordpointer << bitindex;
  bitindex++;
  wordpointer += (bitindex>>3);
  bitindex &= 7;
  return rval>>7;
}

/* End of source */
