/*
 Copyright (C) JAEHYUK CHO
 All rights reserved.
 Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#if !defined(__def_mzapi_source_main_c__)
#define __def_mzapi_source_main_c__ "main.c"

#if defined(WIN32) || defined(_WIN32)
# include <io.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__GNUC__)
# include <unistd.h>
#endif
#include <fcntl.h>

#include "mzmd5.h"

static int (test_md5sum)(const char *s_file_name)
{
 const char *c_roll[] = {"/", "-", "\\", "|"};
 int s_result = (-1);
 int s_handle;
 int s_index;
 void *s_md5;
 int s_read_bytes;
 unsigned char s_buffer[ 64 << 10 ];
 int s_roll_index = 0;
 s_handle = open(s_file_name, O_RDONLY);
 if(s_handle != (-1))
 {
  s_md5 = mzapi_open_md5(); 
  if(s_md5)
  {
   do
   {
    s_read_bytes = read(s_handle, &s_buffer[0], sizeof(s_buffer));
    if(s_read_bytes > 0)
    {
     (void)mzapi_push_md5(s_md5, &s_buffer[0], s_read_bytes);
     (void)fprintf(stdout, "\r[%s]", c_roll[s_roll_index % 4]);
     (void)fflush(stdout);
     s_roll_index++;
    }
   }while(s_read_bytes == sizeof(s_buffer));
   (void)mzapi_close_md5(s_md5, &s_buffer[0]);
   (void)fprintf(stdout, "\r");
   for(s_index = 0;s_index < 16;s_index++)
   {
    (void)fprintf(stdout, "%02X", (unsigned int)s_buffer[s_index]);
   } 
   (void)fprintf(stdout, " %s\n", (char *)s_file_name);
   s_result = 1;
  } 
  (void)close(s_handle);
 }
 else (void)fprintf(stdout, "Can not open file ! (\"%s\")\n", (char *)s_file_name);
 return(s_result);
}

int main(int s_argc, char **s_argv)
{
 int s_index;
 if(s_argc > 1)
 {
  for(s_index = 1;s_index < s_argc;s_index++)(void)test_md5sum(s_argv[s_index]);
 }
 else (void)fprintf(stdout, "usage: %s <file> [<file ...]\n", s_argv[0]);
 return(0);
}

#endif

/* vim: set expandtab: */
/* End of source */
