/*
 Copyright (C) JAEHYUK CHO
 All rights reserved.
 Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#if !defined(__def_mzapi_source_mzmd5_c__)
#define __def_mzapi_source_mzmd5_c__ "mzmd5.c"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mzmd5.h"

#define __def_mzapi_md5_s11__ (7)
#define __def_mzapi_md5_s12__ (12)
#define __def_mzapi_md5_s13__ (17)
#define __def_mzapi_md5_s14__ (22)
#define __def_mzapi_md5_s21__ (5)
#define __def_mzapi_md5_s22__ (9)
#define __def_mzapi_md5_s23__ (14)
#define __def_mzapi_md5_s24__ (20)
#define __def_mzapi_md5_s31__ (4)
#define __def_mzapi_md5_s32__ (11)
#define __def_mzapi_md5_s33__ (16)
#define __def_mzapi_md5_s34__ (23)
#define __def_mzapi_md5_s41__ (6)
#define __def_mzapi_md5_s42__ (10)
#define __def_mzapi_md5_s43__ (15)
#define __def_mzapi_md5_s44__ (21)

#define __def_mzapi_md5_f1__(x,y,z) (((x) & (y)) | ((~x) & (z))) 
#define __def_mzapi_md5_f2__(x,y,z) (((x) & (z)) | ((y) & (~z))) 
#define __def_mzapi_md5_f3__(x,y,z) ((x) ^ (y) ^ (z))
#define __def_mzapi_md5_f4__(x,y,z) ((y) ^ ((x) | (~z)))
#define __def_mzapi_md5_rotate_left__(x,n) (((x) << (n)) | ((x) >> (32 - (n))))

#define __def_mzapi_md5_ff__(a,b,c,d,x,s,ac) do{ \
 (a) += __def_mzapi_md5_f1__((b),(c),(d)) + (x) + (__t_mzapi_dword__)(ac); \
 (a)  = __def_mzapi_md5_rotate_left__((a),(s)); \
 (a) += (b); \
}while(0)

#define __def_mzapi_md5_gg__(a,b,c,d,x,s,ac) do{ \
 (a) += __def_mzapi_md5_f2__((b),(c),(d)) + (x) + (__t_mzapi_dword__)(ac); \
 (a)  = __def_mzapi_md5_rotate_left__((a),(s)); \
 (a) += (b); \
}while(0)

#define __def_mzapi_md5_hh__(a,b,c,d,x,s,ac) do{ \
 (a) += __def_mzapi_md5_f3__((b),(c),(d)) + (x) + (__t_mzapi_dword__)(ac); \
 (a)  = __def_mzapi_md5_rotate_left__((a),(s)); \
 (a) += (b); \
}while(0)

#define __def_mzapi_md5_ii__(a,b,c,d,x,s,ac) do{ \
 (a) += __def_mzapi_md5_f4__((b),(c),(d)) + (x) + (__t_mzapi_dword__)(ac); \
 (a)  = __def_mzapi_md5_rotate_left__((a),(s)); \
 (a) += (b); \
}while(0)

struct __ts_mzapi_md5_local__
{ /* Shadow handle */
 __t_mzapi_dword__ state[ 4 ];
 __t_mzapi_dword__ count[ 2 ];
 __t_mzapi_byte__  buffer[ 64 ];
};

__mzapi_export__ __t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_open_md5)(__t_mzapi_void__);
__mzapi_export__ __t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_close_md5)(__t_mzapi_ptr__ s_handle, __t_mzapi_ptr__ s_digest);
__mzapi_export__ __t_mzapi_void__ (__mzapi_fastcall__ mzapi_push_md5)(__t_mzapi_ptr__ s_handle, __mzapi_const__ __t_mzapi_ptr__ s_buffer, __t_mzapi_size__ s_size);

__mzapi_static__ __t_mzapi_void__ (__mzapi_fastcall__ __mzapi_encode_md5__)(__t_mzapi_byte__ *s_to, __mzapi_const__ __t_mzapi_dword__ *s_from, __t_mzapi_size__ s_size);
__mzapi_static__ __t_mzapi_void__ (__mzapi_fastcall__ __mzapi_decode_md5__)(__t_mzapi_dword__ *s_to, __mzapi_const__ __t_mzapi_byte__ *s_from, __t_mzapi_size__ s_size);
__mzapi_static__ __t_mzapi_void__ (__mzapi_fastcall__ __mzapi_transform_md5__)(__t_mzapi_ptr__ s_buffer, __mzapi_const__ __t_mzapi_ptr__ s_from);

__t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_open_md5)(__t_mzapi_void__)
{
 struct __ts_mzapi_md5_local__ *s_md5;
 s_md5 = (struct __ts_mzapi_md5_local__ *)mzapi_alloc((__t_mzapi_size__)sizeof(struct __ts_mzapi_md5_local__));
 if(s_md5 == ((struct __ts_mzapi_md5_local__ *)0))return(__mzapi_null__);
 s_md5->state[0] = (__t_mzapi_dword__)0x67452301;
 s_md5->state[1] = (__t_mzapi_dword__)0xefcdab89;
 s_md5->state[2] = (__t_mzapi_dword__)0x98badcfe;
 s_md5->state[3] = (__t_mzapi_dword__)0x10325476;
 s_md5->count[0] = (__t_mzapi_dword__)0;
 s_md5->count[1] = (__t_mzapi_dword__)0;
 return((__t_mzapi_ptr__)s_md5);    
}

__t_mzapi_ptr__ (__mzapi_fastcall__ mzapi_close_md5)(__t_mzapi_ptr__ s_handle, __t_mzapi_ptr__ s_digest)
{
 struct __ts_mzapi_md5_local__ *s_md5;
 __t_mzapi_byte__ s_padding[ 64 ];
 __t_mzapi_byte__ s_bits[ 8 ];
 __t_mzapi_byte__ s_dummy_digest[ 16 ];
 __t_mzapi_size__ s_index;
 __t_mzapi_size__ s_padding_size;
 if(s_handle == __mzapi_null__)return(__mzapi_null__);
 s_md5 = (struct __ts_mzapi_md5_local__ *)s_handle;
 (__t_mzapi_void__)mzapi_zero_memory((__t_mzapi_ptr__)(&s_padding[0]), (__t_mzapi_size__)sizeof(s_padding));
 s_padding[0] = (__t_mzapi_byte__)0x80;
 __mzapi_encode_md5__((__t_mzapi_byte__ *)(&s_bits[0]), (__t_mzapi_dword__ *)(&s_md5->count[0]), (__t_mzapi_size__)sizeof(s_bits));
 s_index = (__t_mzapi_size__)((s_md5->count[0] >> 3) & ((__t_mzapi_dword__)0x3f));
 s_padding_size = (s_index < ((__t_mzapi_size__)56)) ? (((__t_mzapi_size__)56) - s_index) : (((__t_mzapi_size__)120) - s_index);
 mzapi_push_md5(s_handle, (__t_mzapi_ptr__ )(&s_padding[0]), s_padding_size);
 mzapi_push_md5(s_handle, (__t_mzapi_ptr__ )(&s_bits[0]), (__t_mzapi_size__)sizeof(s_bits));
 if(s_digest == __mzapi_null__)
 { /* unuse digest part */
  __mzapi_encode_md5__((__t_mzapi_byte__ *)(&s_dummy_digest[0]), (__t_mzapi_dword__ *)(&s_md5->state[0]), (__t_mzapi_size__)(sizeof(__t_mzapi_dword__) << 2));
  (__t_mzapi_void__)mzapi_zero_memory((__t_mzapi_ptr__)(&s_dummy_digest[0]), (__t_mzapi_size__)sizeof(s_dummy_digest));
 }
 else __mzapi_encode_md5__((__t_mzapi_byte__ *)s_digest, (__t_mzapi_dword__ *)(&s_md5->state[0]), (__t_mzapi_size__)(sizeof(__t_mzapi_dword__) << 2));
 (__t_mzapi_void__)mzapi_zero_memory(s_handle, (__t_mzapi_size__)sizeof(struct __ts_mzapi_md5_local__)); 
 (__t_mzapi_void__)mzapi_free(s_handle);
 return(__mzapi_null__);
}

__t_mzapi_void__ (__mzapi_fastcall__ mzapi_push_md5)(__t_mzapi_ptr__ s_handle, __mzapi_const__ __t_mzapi_ptr__ s_buffer, __t_mzapi_size__ s_size)
{
 struct __ts_mzapi_md5_local__ *s_md5;
 __t_mzapi_size__ s_index;
 __t_mzapi_size__ s_count;
 __t_mzapi_size__ s_part_size;
 if(s_handle == __mzapi_null__)return;
 if((s_buffer == __mzapi_null__) || (s_size <= ((__t_mzapi_size__)0)))return;
 s_md5 = (struct __ts_mzapi_md5_local__ *)s_handle;
 s_index = (__t_mzapi_size__)((s_md5->count[0] >> 3) & ((__t_mzapi_dword__)0x3f));
 s_md5->count[0] += ((__t_mzapi_dword__)s_size) << 3;
 if(s_md5->count[0] < ((__t_mzapi_dword__)(s_size << 3)))s_md5->count[1]++; 
 s_md5->count[1] += ((__t_mzapi_dword__)s_size) >> 29;
 s_part_size = ((__t_mzapi_size__)64) - s_index;
 if(s_size >= s_part_size)
 {
  (__t_mzapi_void__)mzapi_copy_memory((__t_mzapi_ptr__ )(&s_md5->buffer[s_index]), s_buffer, (__t_mzapi_size__)s_part_size);
  __mzapi_transform_md5__((__t_mzapi_ptr__ )(&s_md5->state[0]), (__t_mzapi_ptr__ )(&s_md5->buffer[0]));
  for(s_count = s_part_size;(s_count + ((__t_mzapi_size__)63)) < s_size;s_count += ((__t_mzapi_size__)64))
  {
   __mzapi_transform_md5__((__t_mzapi_ptr__)(&s_md5->state[0]), __mzapi_peek_f__(__t_mzapi_ptr__, s_buffer, s_count));
  }
  s_index = (__t_mzapi_size__)0;
 }
 else s_count = 0;
 (__t_mzapi_void__)mzapi_copy_memory((__t_mzapi_ptr__ )(&s_md5->buffer[s_index]), __mzapi_peek_f__(__t_mzapi_ptr__, s_buffer, s_count), (__t_mzapi_size__)(s_size - s_count));
}

__mzapi_static__ __t_mzapi_void__ (__mzapi_fastcall__ __mzapi_encode_md5__)(__t_mzapi_byte__ *s_to, __mzapi_const__ __t_mzapi_dword__ *s_from, __t_mzapi_size__ s_size)
{
 __t_mzapi_size__ s_index0;
 __t_mzapi_size__ s_index1;
 for(s_index0 = s_index1 = (__t_mzapi_size__)0;s_index1 < s_size;s_index0 += ((__t_mzapi_size__)sizeof(__t_mzapi_byte__)), s_index1 += ((__t_mzapi_size__)sizeof(__t_mzapi_dword__)))
 {
  s_to[s_index1 + ((__t_mzapi_size__)0)] = (__t_mzapi_byte__)((s_from[s_index0] >>  0) & ((__t_mzapi_byte__)0xff));
  s_to[s_index1 + ((__t_mzapi_size__)1)] = (__t_mzapi_byte__)((s_from[s_index0] >>  8) & ((__t_mzapi_byte__)0xff));
  s_to[s_index1 + ((__t_mzapi_size__)2)] = (__t_mzapi_byte__)((s_from[s_index0] >> 16) & ((__t_mzapi_byte__)0xff));
  s_to[s_index1 + ((__t_mzapi_size__)3)] = (__t_mzapi_byte__)((s_from[s_index0] >> 24) & ((__t_mzapi_byte__)0xff));
 }
}

__mzapi_static__ __t_mzapi_void__ (__mzapi_fastcall__ __mzapi_decode_md5__)(__t_mzapi_dword__ *s_to, __mzapi_const__ __t_mzapi_byte__ *s_from, __t_mzapi_size__ s_size)
{
 __t_mzapi_size__ s_index0;
 __t_mzapi_size__ s_index1;
 for(s_index0 = s_index1 = (__t_mzapi_size__)0;s_index1 < s_size;s_index0 += ((__t_mzapi_size__)sizeof(__t_mzapi_byte__)), s_index1 += ((__t_mzapi_size__)sizeof(__t_mzapi_dword__)))
 {
  s_to[s_index0] = (((__t_mzapi_dword__)s_from[s_index1 + ((__t_mzapi_size__)0)]) <<  0) |
                   (((__t_mzapi_dword__)s_from[s_index1 + ((__t_mzapi_size__)1)]) <<  8) |
                   (((__t_mzapi_dword__)s_from[s_index1 + ((__t_mzapi_size__)2)]) << 16) |
                   (((__t_mzapi_dword__)s_from[s_index1 + ((__t_mzapi_size__)3)]) << 24); 
 } 
}

__mzapi_static__ __t_mzapi_void__ (__mzapi_fastcall__ __mzapi_transform_md5__)(__t_mzapi_ptr__ s_buffer, __mzapi_const__ __t_mzapi_ptr__ s_from)
{
 __t_mzapi_dword__ a;
 __t_mzapi_dword__ b;
 __t_mzapi_dword__ c;
 __t_mzapi_dword__ d;
 __t_mzapi_dword__ s_from32[ 16 ];

 a = *__mzapi_peek_f__(__t_mzapi_dword__ *, s_buffer, sizeof(__t_mzapi_dword__) * 0);
 b = *__mzapi_peek_f__(__t_mzapi_dword__ *, s_buffer, sizeof(__t_mzapi_dword__) * 1);
 c = *__mzapi_peek_f__(__t_mzapi_dword__ *, s_buffer, sizeof(__t_mzapi_dword__) * 2);
 d = *__mzapi_peek_f__(__t_mzapi_dword__ *, s_buffer, sizeof(__t_mzapi_dword__) * 3);
 
 __mzapi_decode_md5__((__t_mzapi_dword__ *)(&s_from32[0]), (__t_mzapi_byte__ *)s_from, (__t_mzapi_size__)64);
 
 __def_mzapi_md5_ff__(a, b, c, d, s_from32[ 0], __def_mzapi_md5_s11__, 0xd76aa478); /* 1 */
 __def_mzapi_md5_ff__(d, a, b, c, s_from32[ 1], __def_mzapi_md5_s12__, 0xe8c7b756); /* 2 */
 __def_mzapi_md5_ff__(c, d, a, b, s_from32[ 2], __def_mzapi_md5_s13__, 0x242070db); /* 3 */
 __def_mzapi_md5_ff__(b, c, d, a, s_from32[ 3], __def_mzapi_md5_s14__, 0xc1bdceee); /* 4 */
 __def_mzapi_md5_ff__(a, b, c, d, s_from32[ 4], __def_mzapi_md5_s11__, 0xf57c0faf); /* 5 */
 __def_mzapi_md5_ff__(d, a, b, c, s_from32[ 5], __def_mzapi_md5_s12__, 0x4787c62a); /* 6 */
 __def_mzapi_md5_ff__(c, d, a, b, s_from32[ 6], __def_mzapi_md5_s13__, 0xa8304613); /* 7 */
 __def_mzapi_md5_ff__(b, c, d, a, s_from32[ 7], __def_mzapi_md5_s14__, 0xfd469501); /* 8 */
 __def_mzapi_md5_ff__(a, b, c, d, s_from32[ 8], __def_mzapi_md5_s11__, 0x698098d8); /* 9 */
 __def_mzapi_md5_ff__(d, a, b, c, s_from32[ 9], __def_mzapi_md5_s12__, 0x8b44f7af); /* 10 */
 __def_mzapi_md5_ff__(c, d, a, b, s_from32[10], __def_mzapi_md5_s13__, 0xffff5bb1); /* 11 */
 __def_mzapi_md5_ff__(b, c, d, a, s_from32[11], __def_mzapi_md5_s14__, 0x895cd7be); /* 12 */
 __def_mzapi_md5_ff__(a, b, c, d, s_from32[12], __def_mzapi_md5_s11__, 0x6b901122); /* 13 */
 __def_mzapi_md5_ff__(d, a, b, c, s_from32[13], __def_mzapi_md5_s12__, 0xfd987193); /* 14 */
 __def_mzapi_md5_ff__(c, d, a, b, s_from32[14], __def_mzapi_md5_s13__, 0xa679438e); /* 15 */
 __def_mzapi_md5_ff__(b, c, d, a, s_from32[15], __def_mzapi_md5_s14__, 0x49b40821); /* 16 */

 __def_mzapi_md5_gg__(a, b, c, d, s_from32[ 1], __def_mzapi_md5_s21__, 0xf61e2562); /* 17 */
 __def_mzapi_md5_gg__(d, a, b, c, s_from32[ 6], __def_mzapi_md5_s22__, 0xc040b340); /* 18 */
 __def_mzapi_md5_gg__(c, d, a, b, s_from32[11], __def_mzapi_md5_s23__, 0x265e5a51); /* 19 */
 __def_mzapi_md5_gg__(b, c, d, a, s_from32[ 0], __def_mzapi_md5_s24__, 0xe9b6c7aa); /* 20 */
 __def_mzapi_md5_gg__(a, b, c, d, s_from32[ 5], __def_mzapi_md5_s21__, 0xd62f105d); /* 21 */
 __def_mzapi_md5_gg__(d, a, b, c, s_from32[10], __def_mzapi_md5_s22__, 0x02441453); /* 22 */
 __def_mzapi_md5_gg__(c, d, a, b, s_from32[15], __def_mzapi_md5_s23__, 0xd8a1e681); /* 23 */
 __def_mzapi_md5_gg__(b, c, d, a, s_from32[ 4], __def_mzapi_md5_s24__, 0xe7d3fbc8); /* 24 */
 __def_mzapi_md5_gg__(a, b, c, d, s_from32[ 9], __def_mzapi_md5_s21__, 0x21e1cde6); /* 25 */
 __def_mzapi_md5_gg__(d, a, b, c, s_from32[14], __def_mzapi_md5_s22__, 0xc33707d6); /* 26 */
 __def_mzapi_md5_gg__(c, d, a, b, s_from32[ 3], __def_mzapi_md5_s23__, 0xf4d50d87); /* 27 */
 __def_mzapi_md5_gg__(b, c, d, a, s_from32[ 8], __def_mzapi_md5_s24__, 0x455a14ed); /* 28 */
 __def_mzapi_md5_gg__(a, b, c, d, s_from32[13], __def_mzapi_md5_s21__, 0xa9e3e905); /* 29 */
 __def_mzapi_md5_gg__(d, a, b, c, s_from32[ 2], __def_mzapi_md5_s22__, 0xfcefa3f8); /* 30 */
 __def_mzapi_md5_gg__(c, d, a, b, s_from32[ 7], __def_mzapi_md5_s23__, 0x676f02d9); /* 31 */
 __def_mzapi_md5_gg__(b, c, d, a, s_from32[12], __def_mzapi_md5_s24__, 0x8d2a4c8a); /* 32 */

 __def_mzapi_md5_hh__(a, b, c, d, s_from32[ 5], __def_mzapi_md5_s31__, 0xfffa3942); /* 33 */
 __def_mzapi_md5_hh__(d, a, b, c, s_from32[ 8], __def_mzapi_md5_s32__, 0x8771f681); /* 34 */
 __def_mzapi_md5_hh__(c, d, a, b, s_from32[11], __def_mzapi_md5_s33__, 0x6d9d6122); /* 35 */
 __def_mzapi_md5_hh__(b, c, d, a, s_from32[14], __def_mzapi_md5_s34__, 0xfde5380c); /* 36 */
 __def_mzapi_md5_hh__(a, b, c, d, s_from32[ 1], __def_mzapi_md5_s31__, 0xa4beea44); /* 37 */
 __def_mzapi_md5_hh__(d, a, b, c, s_from32[ 4], __def_mzapi_md5_s32__, 0x4bdecfa9); /* 38 */
 __def_mzapi_md5_hh__(c, d, a, b, s_from32[ 7], __def_mzapi_md5_s33__, 0xf6bb4b60); /* 39 */
 __def_mzapi_md5_hh__(b, c, d, a, s_from32[10], __def_mzapi_md5_s34__, 0xbebfbc70); /* 40 */
 __def_mzapi_md5_hh__(a, b, c, d, s_from32[13], __def_mzapi_md5_s31__, 0x289b7ec6); /* 41 */
 __def_mzapi_md5_hh__(d, a, b, c, s_from32[ 0], __def_mzapi_md5_s32__, 0xeaa127fa); /* 42 */
 __def_mzapi_md5_hh__(c, d, a, b, s_from32[ 3], __def_mzapi_md5_s33__, 0xd4ef3085); /* 43 */
 __def_mzapi_md5_hh__(b, c, d, a, s_from32[ 6], __def_mzapi_md5_s34__, 0x04881d05); /* 44 */
 __def_mzapi_md5_hh__(a, b, c, d, s_from32[ 9], __def_mzapi_md5_s31__, 0xd9d4d039); /* 45 */
 __def_mzapi_md5_hh__(d, a, b, c, s_from32[12], __def_mzapi_md5_s32__, 0xe6db99e5); /* 46 */
 __def_mzapi_md5_hh__(c, d, a, b, s_from32[15], __def_mzapi_md5_s33__, 0x1fa27cf8); /* 47 */
 __def_mzapi_md5_hh__(b, c, d, a, s_from32[ 2], __def_mzapi_md5_s34__, 0xc4ac5665); /* 48 */

 __def_mzapi_md5_ii__(a, b, c, d, s_from32[ 0], __def_mzapi_md5_s41__, 0xf4292244); /* 49 */
 __def_mzapi_md5_ii__(d, a, b, c, s_from32[ 7], __def_mzapi_md5_s42__, 0x432aff97); /* 50 */
 __def_mzapi_md5_ii__(c, d, a, b, s_from32[14], __def_mzapi_md5_s43__, 0xab9423a7); /* 51 */
 __def_mzapi_md5_ii__(b, c, d, a, s_from32[ 5], __def_mzapi_md5_s44__, 0xfc93a039); /* 52 */
 __def_mzapi_md5_ii__(a, b, c, d, s_from32[12], __def_mzapi_md5_s41__, 0x655b59c3); /* 53 */
 __def_mzapi_md5_ii__(d, a, b, c, s_from32[ 3], __def_mzapi_md5_s42__, 0x8f0ccc92); /* 54 */
 __def_mzapi_md5_ii__(c, d, a, b, s_from32[10], __def_mzapi_md5_s43__, 0xffeff47d); /* 55 */
 __def_mzapi_md5_ii__(b, c, d, a, s_from32[ 1], __def_mzapi_md5_s44__, 0x85845dd1); /* 56 */
 __def_mzapi_md5_ii__(a, b, c, d, s_from32[ 8], __def_mzapi_md5_s41__, 0x6fa87e4f); /* 57 */
 __def_mzapi_md5_ii__(d, a, b, c, s_from32[15], __def_mzapi_md5_s42__, 0xfe2ce6e0); /* 58 */
 __def_mzapi_md5_ii__(c, d, a, b, s_from32[ 6], __def_mzapi_md5_s43__, 0xa3014314); /* 59 */
 __def_mzapi_md5_ii__(b, c, d, a, s_from32[13], __def_mzapi_md5_s44__, 0x4e0811a1); /* 60 */
 __def_mzapi_md5_ii__(a, b, c, d, s_from32[ 4], __def_mzapi_md5_s41__, 0xf7537e82); /* 61 */
 __def_mzapi_md5_ii__(d, a, b, c, s_from32[11], __def_mzapi_md5_s42__, 0xbd3af235); /* 62 */
 __def_mzapi_md5_ii__(c, d, a, b, s_from32[ 2], __def_mzapi_md5_s43__, 0x2ad7d2bb); /* 63 */
 __def_mzapi_md5_ii__(b, c, d, a, s_from32[ 9], __def_mzapi_md5_s44__, 0xeb86d391); /* 64 */
 
 *(__mzapi_peek_f__(__t_mzapi_dword__ *, s_buffer, sizeof(__t_mzapi_dword__) * 0)) += a;
 *(__mzapi_peek_f__(__t_mzapi_dword__ *, s_buffer, sizeof(__t_mzapi_dword__) * 1)) += b;
 *(__mzapi_peek_f__(__t_mzapi_dword__ *, s_buffer, sizeof(__t_mzapi_dword__) * 2)) += c;
 *(__mzapi_peek_f__(__t_mzapi_dword__ *, s_buffer, sizeof(__t_mzapi_dword__) * 3)) += d;
 
 (__t_mzapi_void__)mzapi_zero_memory((__t_mzapi_ptr__ )(&s_from32[0]), (__t_mzapi_size__)sizeof(s_from32));
}

#endif

/* vim: set expandtab: */
/* End of source */
