/*
 Copyright (C) JAEHYUK CHO
 All rights reserved.
 
 Author: JaeHyuk Cho <minzkn@minzkn.com>
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mzcrc.h"

int main(int s_argc, char **s_argv);

int main(int s_argc, char **s_argv)
{
    (void)s_argc;
    (void)s_argv;
    
    do {
        char s_test_data[] = {
         '1', '2', '3', '4', '5', '6', '7', '8', '9'
        }; /* CRC16=BB3DH, CRC32=CBF43926H, CRC64=B90956C775A41001H */
        size_t s_offset;

        mz_crc16_t s_crc16;
        mz_crc32_t s_crc32;
        mz_crc64_t s_crc64;

        s_crc16 = def_mz_crc16_init;
        for(s_offset = ((size_t)0);s_offset < sizeof(s_test_data);s_offset++) {
            s_crc16 = mz_crc16((s_offset == ((size_t)0)) ? 1 : 0, s_crc16, (const void *)(&s_test_data[s_offset]), sizeof(char));
        }
        (void)fprintf(stdout,
            "mz_crc16(?BB3DH): %08lXH (%lu) - %08lXH (%lu)\n",
            (unsigned long)s_crc16,
            (unsigned long)s_crc16,
            (unsigned long)mz_crc16(1, def_mz_crc16_init, (const void *)(&s_test_data[0]), sizeof(s_test_data)),
            (unsigned long)mz_crc16(1, def_mz_crc16_init, (const void *)(&s_test_data[0]), sizeof(s_test_data))
        );
        
        s_crc32 = def_mz_crc32_init;
        for(s_offset = ((size_t)0);s_offset < sizeof(s_test_data);s_offset++) {
            s_crc32 = mz_crc32((s_offset == ((size_t)0)) ? 1 : 0, s_crc32, (const void *)(&s_test_data[s_offset]), sizeof(char));
        }
        (void)fprintf(stdout,
            "mz_crc32(?CBF43926H): %08lXH (%lu) - %08lXH (%lu)\n",
            (unsigned long)s_crc32,
            (unsigned long)s_crc32,
            (unsigned long)mz_crc32(1, def_mz_crc32_init, (const void *)(&s_test_data[0]), sizeof(s_test_data)),
            (unsigned long)mz_crc32(1, def_mz_crc32_init, (const void *)(&s_test_data[0]), sizeof(s_test_data))
        );
        
	s_crc32 = def_mz_crc32c_init;
        for(s_offset = ((size_t)0);s_offset < sizeof(s_test_data);s_offset++) {
            s_crc32 = mz_crc32c((s_offset == ((size_t)0)) ? 1 : 0, s_crc32, (const void *)(&s_test_data[s_offset]), sizeof(char));
        }
        (void)fprintf(stdout,
            "mz_crc32c(?E3069283H): %08lXH (%lu) - %08lXH (%lu)\n",
            (unsigned long)s_crc32,
            (unsigned long)s_crc32,
            (unsigned long)mz_crc32c(1, def_mz_crc32c_init, (const void *)(&s_test_data[0]), sizeof(s_test_data)),
            (unsigned long)mz_crc32c(1, def_mz_crc32c_init, (const void *)(&s_test_data[0]), sizeof(s_test_data))
        );
        
        s_crc64 = def_mz_crc64_init;
        for(s_offset = ((size_t)0);s_offset < sizeof(s_test_data);s_offset++) {
            s_crc64 = mz_crc64((s_offset == ((size_t)0)) ? 1 : 0, s_crc64, (const void *)(&s_test_data[s_offset]), sizeof(char));
        }
        (void)fprintf(stdout,
            "mz_crc64(?B90956C775A41001H): %08llXH (%llu) - %08llXH (%llu)\n",
            (unsigned long long)s_crc64,
            (unsigned long long)s_crc64,
            (unsigned long long)mz_crc64(1, def_mz_crc64_init, (const void *)(&s_test_data[0]), sizeof(s_test_data)),
            (unsigned long long)mz_crc64(1, def_mz_crc64_init, (const void *)(&s_test_data[0]), sizeof(s_test_data))
        );
    }while(0);

#if 0L /* CRC32c TEST WITH VECTOR-LIST */
    do {
        struct {
            mz_crc32_t m_result;
            const char *m_string;
        } c_test_vector[] = {
            {0x00000000, ""},
            {0x22620404, "The quick brown fox jumps over the lazy dog"},
            {0xC1D04330, "a"},
            {0x364B3FB7, "abc"},
            {0x02BD79D0, "message digest"},
            {0x9EE6EF25, "abcdefghijklmnopqrstuvwxyz"},
            {0xA245D57D, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789"},
            {0x477A6781, "12345678901234567890123456789012345678901234567890123456789012345678901234567890"},
            {0xE3069283, "123456789"},
            {0x00000000, (const char *)0}
        };
        const size_t c_consume_size = (size_t)3u;
        int s_test_index;
        size_t s_size;
        size_t s_offset;
        size_t s_this_size;
        mz_crc32_t s_seed;

        for(s_test_index = 0;c_test_vector[s_test_index].m_string != ((const char *)0);s_test_index++) {
            s_size = strlen(c_test_vector[s_test_index].m_string);
            s_offset = (size_t)0u;
            s_this_size = s_size - s_offset;
            if(s_this_size > c_consume_size) {
                s_this_size = c_consume_size;
            }
            s_seed = mz_crc32c_first((const void *)(&c_test_vector[s_test_index].m_string[s_offset]), s_this_size);
            s_offset += s_this_size;
            while(s_offset < s_size) {
                s_this_size = s_size - s_offset;
                if(s_this_size > c_consume_size) {
                    s_this_size = c_consume_size;
                }
                s_seed = mz_crc32c_update(s_seed, (const void *)(&c_test_vector[s_test_index].m_string[s_offset]), s_this_size);
                s_offset += s_this_size;
            }

            (void)fprintf(
                stdout,
                "[%s] CRC32c-TEST-VECTOR=%08lXH, %08lXH <= \"%s\"\n",
                (c_test_vector[s_test_index].m_result == s_seed) ? "PASS" : "FAIL",
                (unsigned long)c_test_vector[s_test_index].m_result,
                (unsigned long)s_seed,
                c_test_vector[s_test_index].m_string
            );
        }
    }while(0);
#endif

    return(EXIT_SUCCESS);
}

/* vim: set expandtab: */
/* End of source */
