/*
 Copyright (C) JAEHYUK CHO
 All rights reserved.
 
 Author: JaeHyuk Cho <minzkn@minzkn.com>
*/

#include <stdio.h>
#include <stdlib.h>

#include "mzcrc.h"

int main(int s_argc, char **s_argv);

int main(int s_argc, char **s_argv)
{
    (void)s_argc;
    (void)s_argv;
    
    do {
        char s_test_data[] = {
         '1', '2', '3', '4', '5', '6', '7', '8', '9'
        }; /* CRC16=BB3DH, CRC32=CBF43926H, CRC64=B90956C775A41001H */
        size_t s_offset;

        mz_crc16_t s_crc16;
        mz_crc32_t s_crc32;
        mz_crc64_t s_crc64;

        s_crc16 = def_mz_crc16_init;
        for(s_offset = ((size_t)0);s_offset < sizeof(s_test_data);s_offset++) {
            s_crc16 = mz_crc16((s_offset == ((size_t)0)) ? 1 : 0, s_crc16, (const void *)(&s_test_data[s_offset]), sizeof(char));
        }
        (void)fprintf(stdout,
            "mz_crc16(?BB3DH): %08lXH (%lu) - %08lXH (%lu)\n",
            (unsigned long)s_crc16,
            (unsigned long)s_crc16,
            (unsigned long)mz_crc16(1, def_mz_crc16_init, (const void *)(&s_test_data[0]), sizeof(s_test_data)),
            (unsigned long)mz_crc16(1, def_mz_crc16_init, (const void *)(&s_test_data[0]), sizeof(s_test_data))
        );
        
        s_crc32 = def_mz_crc32_init;
        for(s_offset = ((size_t)0);s_offset < sizeof(s_test_data);s_offset++) {
            s_crc32 = mz_crc32((s_offset == ((size_t)0)) ? 1 : 0, s_crc32, (const void *)(&s_test_data[s_offset]), sizeof(char));
        }
        (void)fprintf(stdout,
            "mz_crc32(?CBF43926H): %08lXH (%lu) - %08lXH (%lu)\n",
            (unsigned long)s_crc32,
            (unsigned long)s_crc32,
            (unsigned long)mz_crc32(1, def_mz_crc32_init, (const void *)(&s_test_data[0]), sizeof(s_test_data)),
            (unsigned long)mz_crc32(1, def_mz_crc32_init, (const void *)(&s_test_data[0]), sizeof(s_test_data))
        );
        
        s_crc64 = def_mz_crc64_init;
        for(s_offset = ((size_t)0);s_offset < sizeof(s_test_data);s_offset++) {
            s_crc64 = mz_crc64((s_offset == ((size_t)0)) ? 1 : 0, s_crc64, (const void *)(&s_test_data[s_offset]), sizeof(char));
        }
        (void)fprintf(stdout,
            "mz_crc64(?B90956C775A41001H): %08llXH (%llu) - %08llXH (%llu)\n",
            (unsigned long long)s_crc64,
            (unsigned long long)s_crc64,
            (unsigned long long)mz_crc64(1, def_mz_crc64_init, (const void *)(&s_test_data[0]), sizeof(s_test_data)),
            (unsigned long long)mz_crc64(1, def_mz_crc64_init, (const void *)(&s_test_data[0]), sizeof(s_test_data))
        );
    }while(0);

    return(EXIT_SUCCESS);
}

/* vim: set expandtab: */
/* End of source */
