/*
    Copyright (C) HWPORT.COM
    All rights reserved.
    Author: JAEHYUK CHO <mailto:minzkn@minzkn.com>
*/

#if !defined(_ISOC99_SOURCE)
# define _ISOC99_SOURCE (1L)
#endif

#if !defined(_GNU_SOURCE)
# define _GNU_SOURCE (1L)
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>

int hwport_launcher(void);

static void mysignal_handler(int s_signum);

int main(int s_argc, char **s_argv);

static int g_is_break = 0;

int hwport_launcher(void)
{
    pid_t s_pid;

    for(;;) {
        s_pid = fork();
        if(s_pid == ((pid_t)(-1))) {
            return(-1);
        }
        else if(s_pid == ((pid_t)0)) {
            /* ok. immortal process start */
            
            /* need to default signal handler ! */
#if defined(SIGBUS)            
            (void)signal(SIGBUS, SIG_DFL);
#endif
#if defined(SIGSTKFLT)
            (void)signal(SIGSTKFLT, SIG_DFL);
#endif            
            (void)signal(SIGILL, SIG_DFL);
            (void)signal(SIGFPE, SIG_DFL);
            (void)signal(SIGSEGV, SIG_DFL);
            break;
        }
        else {
            pid_t s_waitpid_check;
            int s_status = 0;
            int s_options = 0;
            int s_signum = (-1);
          
#if 1L /* DEBUG - SIGINT */ 
            (void)signal(SIGINT, SIG_IGN);
#endif
 
            (void)fprintf(stdout, "Start monitoring by hwport_launcher ! (pid=%ld)\n", (long)s_pid);
            
#if defined(WUNTRACED)
            s_options |= WUNTRACED;
#endif
#if defined(WCONTINUED)
            s_options |= WCONTINUED;
#endif

            do {
                s_waitpid_check = waitpid(s_pid, (int *)(&s_status), s_options);
                if(s_waitpid_check == ((pid_t)(-1))) {
                    /* what happen ? */
             
                    (void)fprintf(stderr, "Waitpid failed by hwport_launcher ! (pid=%ld)\n", (long)s_pid);

                    exit(EXIT_SUCCESS);
                } 

                if(WIFEXITED(s_status) != 0) {
                    /* normal exit */
                    
                    (void)fprintf(stdout, "Stop monitoring by hwport_launcher ! (pid=%long)\n", (long)s_pid);

                    exit(EXIT_SUCCESS);
                }
                else if(WIFSIGNALED(s_status) != 0) {
                    s_signum = WTERMSIG(s_status);
                    if(
#if defined(SIGBUS)
                        (s_signum != SIGBUS) &&
#endif
#if defined(SIGSTKFLT)
                        (s_signum != SIGSTKFLT) &&
#endif
                        (s_signum != SIGILL) &&
                        (s_signum != SIGFPE) &&
                        (s_signum != SIGSEGV) &&
                        (s_signum != SIGPIPE)) {
                        /* normal exit */

                        (void)fprintf(stdout, "Stop monitoring by hwport_launcher ! (pid=%long, signum=%d)\n", (long)s_pid, s_signum);

                        exit(EXIT_SUCCESS);
                    }
                }
            }while((WIFEXITED(s_status) == 0) && (WIFSIGNALED(s_status) == 0));

            (void)fprintf(stdout, "Restarting by hwport_launcher ! (pid=%ld, signum=%d)\n", (long)s_pid, s_signum);

            sleep(3);

            /* retry launch loop */
        }
    }

    return(0);
}

static void mysignal_handler(int s_signum)
{
    (void)fprintf(stderr, "CTRL+C\n");

    g_is_break = 1;

    (void)signal(s_signum, &mysignal_handler);
}

int main(int s_argc, char **s_argv)
{
    int s_ticks;

    (void)s_argc;
    (void)s_argv;

    (void)fprintf(stdout, "BEGIN TEST...\n");

    if(hwport_launcher() == (-1)) {
        (void)fprintf(stderr, "hwport_launcher failed !\n");
    }

    (void)signal(SIGINT, &mysignal_handler); /* CTRL+C */

    for(s_ticks = 0;(s_ticks < 60) && (g_is_break == 0);s_ticks++) {
        (void)fprintf(stdout, "alive (ticks=%d)\n", s_ticks);

        if(s_ticks == 10) {
            *((unsigned long *)0) = 1234; /* segment fault ! */
        }

        sleep(1);
    }

    (void)fprintf(stdout, "END TEST...\n");

    return(EXIT_SUCCESS);
}

/* vim: set expandtab: */
/* End of source */
