/*
  Copyright (C) HWPORT.COM
  All rights reserved.
  Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#if !defined(_ISOC99_SOURCE)
# define _ISOC99_SOURCE (1L)
#endif

#if !defined(_GNU_SOURCE)
# define _GNU_SOURCE (1L)
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <arpa/inet.h>

int main(int s_argc, char **s_argv);

int main(int s_argc, char **s_argv)
{
    const char *s_name;
    const char *s_port_string;

    struct addrinfo s_addrinfo_hints;
    struct addrinfo *s_addrinfo_result;

    int s_check;

    s_name = (s_argc < 2) ? "www.ietf.org" : s_argv[1];
    s_port_string = (s_argc < 3) ? ((const char *)0) : s_argv[2];

    (void)fprintf(stdout, "Trying %s %s\n\n", s_name, (s_port_string == ((const char *)0)) ? "NULL" : s_port_string);

    (void)memset((void *)(&s_addrinfo_hints), 0, sizeof(s_addrinfo_hints));
    s_addrinfo_hints.ai_flags = 0;
    s_addrinfo_hints.ai_family = AF_UNSPEC;

    if(s_port_string == ((const char *)0)) {
        s_addrinfo_hints.ai_socktype = SOCK_RAW;
        s_addrinfo_hints.ai_protocol = 0;
    }
    else {
        s_addrinfo_hints.ai_socktype = SOCK_DGRAM;
        s_addrinfo_hints.ai_protocol = IPPROTO_UDP;
    }
   
    s_addrinfo_result = (struct addrinfo *)0;
    s_check = getaddrinfo(
        (const char *)s_name,
        (const char *)s_port_string,
        (const struct addrinfo *)(&s_addrinfo_hints),
        (struct addrinfo **)(&s_addrinfo_result)
    );
    if(s_check != 0) {
        (void)fprintf(
            stderr,
            "getaddrinfo failed ! (\"%s\")\n",
            gai_strerror(s_check)
        );
        return(EXIT_FAILURE);
    }

    if(s_addrinfo_result == ((struct addrinfo *)0)) {
        (void)fprintf(stdout, "empty address...\n");
    }
    else {
        struct addrinfo *s_addrinfo_trace;
        char s_address_string[ 64 ];

        for(s_addrinfo_trace = s_addrinfo_result;s_addrinfo_trace != ((struct addrinfo *)0);s_addrinfo_trace = s_addrinfo_trace->ai_next) {
            if(s_addrinfo_trace->ai_family == AF_INET) {
                struct sockaddr_in *s_sockaddr_in4;

                s_sockaddr_in4 = (struct sockaddr_in *)s_addrinfo_trace->ai_addr;

                (void)fprintf(
                    stdout,
                    "IPv4: \"%s\" %d\n",
                    inet_ntop(s_addrinfo_trace->ai_family, (const void *)(&s_sockaddr_in4->sin_addr), (char *)(&s_address_string[0]), (socklen_t)sizeof(s_address_string)),
                    ntohs(s_sockaddr_in4->sin_port)
                );
            }
            else if(s_addrinfo_trace->ai_family == AF_INET6) {
                struct sockaddr_in6 *s_sockaddr_in6;

                s_sockaddr_in6 = (struct sockaddr_in6 *)s_addrinfo_trace->ai_addr;

                (void)fprintf(
                    stdout,
                    "IPv6: \"%s\" %d (scope_id=%d)\n",
                    inet_ntop(s_addrinfo_trace->ai_family, (const void *)(&s_sockaddr_in6->sin6_addr), (char *)(&s_address_string[0]), (socklen_t)sizeof(s_address_string)),
                    ntohs(s_sockaddr_in6->sin6_port),
                    (int)(s_sockaddr_in6->sin6_scope_id)
                );
            }
            else {
                (void)fprintf(stdout, "unknown ai_family = %d\n", (int)s_addrinfo_trace->ai_family);
            }
        }

        freeaddrinfo(s_addrinfo_result);
    }

    return(EXIT_SUCCESS);
}

/* vim: set expandtab: */
/* End of source */
