/*
  Copyright (C) JAEHYUK CHO
  All rights reserved.
  Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#include <sys/types.h>
#include <sys/select.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <signal.h>

#include <linux/fb.h>

#define DEF_FBIOGET_VSCREENINFO         0x4600
#define DEF_FBIOGET_FSCREENINFO         0x4602

typedef struct ts_DFB
{
 int                                  Handle;
 int                                  ResX, ResY, ResB, RealX, RealY;
 unsigned long                        MapSize;
 void                                *DirectMap;
 int                                 *Table;
}t_DFB;

volatile int g_break_fire = 0;

static void fire_signal(int s_signal)
{
 g_break_fire = 1;
 (void)signal(s_signal, fire_signal);
}

static void (fire_load_balance)(void)
{
 struct timeval s_timeval = {0l, 1000000l / 100l /* hz */};
 (void)select(0, (fd_set *)0, (fd_set *)0, (fd_set *)0, (struct timeval *)(&s_timeval));
}

static t_DFB *MZ_DFB_Close(t_DFB *s_Handle)
{
 if(s_Handle)
 {
  if(s_Handle->Table)free(s_Handle->Table);
  if(s_Handle->DirectMap && s_Handle->MapSize > 0lu)munmap(s_Handle->DirectMap, s_Handle->MapSize);
  if(s_Handle->Handle >= 0)close(s_Handle->Handle);
  free(s_Handle);
 }
 /* else Error!!! */
 return(s_Handle);
}

static int MZ_DFB_Detect(t_DFB *s_Handle)
{
 int s_Return = (-1);
 struct fb_fix_screeninfo s_fix; 
 struct fb_var_screeninfo s_var; 
 unsigned long s_AvailMapSize;    
 if(s_Handle)
 {
  if(s_Handle->Handle >= 0)
  {
   if((ioctl((int)s_Handle->Handle, FBIOGET_FSCREENINFO, (&s_fix)) == 0) &&
      (ioctl((int)s_Handle->Handle, FBIOGET_VSCREENINFO, (&s_var)) == 0))
   {
    size_t s_page_size;
    size_t s_alignment_miss_size;
    s_page_size = (size_t)(4 << 10);
    s_alignment_miss_size = ((size_t)s_fix.smem_start) % s_page_size;
    s_Handle->RealX = (int)s_var.xres;
    s_Handle->ResX = (int)(s_fix.line_length / (s_var.bits_per_pixel >> 3));
    s_Handle->RealY = s_Handle->ResY = (int)s_var.yres;
    s_Handle->ResB = (int)s_var.bits_per_pixel >> 3;
    s_Handle->MapSize = (unsigned long)s_Handle->ResX * (unsigned long)s_Handle->ResY * (unsigned long)s_Handle->ResB;
    s_AvailMapSize    = (unsigned long)s_Handle->ResX * (unsigned long)s_Handle->ResY * (unsigned long)(s_var.bits_per_pixel & 0x07lu);
    s_Handle->MapSize+= (s_AvailMapSize >> 3) + ((s_AvailMapSize & 0x07) ? 1 : 0);
    if(s_alignment_miss_size != ((size_t)0))s_Handle->MapSize += s_page_size;
    s_Handle->DirectMap = mmap((void *)0, s_Handle->MapSize, PROT_READ | PROT_WRITE, MAP_SHARED, s_Handle->Handle, 0); 
    if(s_Handle->DirectMap != (void *)(-1))
    {
     if(s_alignment_miss_size != ((size_t)0))
     {
      s_Handle->DirectMap = ((unsigned char *)s_Handle->DirectMap) + s_alignment_miss_size;
      (void)fprintf(stdout, "fix alignment map\n");
     }
     s_Handle->DirectMap = s_Handle->DirectMap;
     if(s_Handle->Table)free(s_Handle->Table);
     s_Handle->Table = (int *)malloc(s_Handle->ResY * sizeof(int));
     if(s_Handle->Table)
     {
      for(s_Return = 0;s_Return < s_Handle->ResY;s_Return++)*(s_Handle->Table + s_Return) = s_Return * s_Handle->ResX * s_Handle->ResB; 
      s_Return = 1;
     }
     /* else Error!!! */
    }
    /* else Error!!! */
   }
   /* else Error!!! */
  }
  /* else Error!!! */
 }
 /* else Error!!! */
 return(s_Return);
}

static t_DFB *MZ_DFB_Open(const char *s_dev)
{
 t_DFB *s_Return = (t_DFB *)malloc(sizeof(t_DFB));
 if(s_Return)
 {
  t_DFB *s_Handle = s_Return;	 
  /* memset((void *)s_Return, 0, sizeof(t_DFB)); */
  s_Handle->Handle = open(s_dev, O_RDWR);
  if(s_Handle->Handle >= 0)
  {   
   if(MZ_DFB_Detect(s_Handle) >= 0)s_Return = s_Handle;
   /* else Error!!! */
  }
  /* else Error!!! */
 }
 /* else Error!!! */
 return(s_Return);
}

int main(int s_argc, char **s_argv)
{
 t_DFB *s_DFB = MZ_DFB_Open(s_argc >= 2 ? s_argv[1] : "/dev/fb0");
 (void)signal(SIGINT, fire_signal);
 if(s_DFB)
 {
  unsigned char *s_ColorMAP = (unsigned char *)malloc(s_DFB->ResX * s_DFB->ResY);
  if(s_DFB->ResB != 2)
  {
   fprintf(stdout, "Not support %d bit color !!!\n", s_DFB->ResB << 3);
   if(s_ColorMAP)free(s_ColorMAP);
   MZ_DFB_Close(s_DFB);
   exit(0);
  }
  if(s_ColorMAP)
  {
   int s_Entry, s_Limit, s_FrameCount = 0, s_ColorType = 0, s_ColorTable[256], s_Count;
   /* memset(s_ColorMAP, 0, s_DFB->ResX * s_DFB->ResY); */
   s_Limit = s_DFB->ResX * (s_DFB->ResY - 128);
   for(s_Count = 0;s_Count < 64;s_Count++)s_ColorTable[s_Count + 192] = ((63 >> 1) << 11) | (63 << 5) | (63 >> 1);
   do
   {
    if(s_FrameCount == 0)
    {
     if(s_ColorType == 0)
     {	     
      for(s_Count = 0;s_Count < 64;s_Count++)s_ColorTable[s_Count +   0] = (s_Count >> 1) << 11;
      for(s_Count = 0;s_Count < 64;s_Count++)s_ColorTable[s_Count +  64] = ((63 >> 1) << 11) | (s_Count << 5);
      for(s_Count = 0;s_Count < 64;s_Count++)s_ColorTable[s_Count + 128] = ((63 >> 1) << 11) | (63 << 5) | (s_Count >> 1);
     }
     else if(s_ColorType == 1)
     {
      for(s_Count = 0;s_Count < 64;s_Count++)s_ColorTable[s_Count +   0] = s_Count << 5;
      for(s_Count = 0;s_Count < 64;s_Count++)s_ColorTable[s_Count +  64] = (63 << 5) | (s_Count >> 1);
      for(s_Count = 0;s_Count < 64;s_Count++)s_ColorTable[s_Count + 128] = ((s_Count >> 1) << 11) | (63 << 5) | (63 >> 1);
     }
     else
     {
      for(s_Count = 0;s_Count < 64;s_Count++)s_ColorTable[s_Count +   0] = (s_Count >> 1);
      for(s_Count = 0;s_Count < 64;s_Count++)s_ColorTable[s_Count +  64] = (s_Count << 5) | (63 >> 1);
      for(s_Count = 0;s_Count < 64;s_Count++)s_ColorTable[s_Count + 128] = ((s_Count >> 1) << 11) | (63 << 5) | (63 >> 1);
     }
    }
    s_Entry = (s_DFB->ResX * (s_DFB->ResY - 1));   
    for(s_Count = 0;s_Count < (s_DFB->RealX >> 3);s_Count++)s_ColorMAP[s_Entry + (rand() % s_DFB->RealX)] = s_ColorTable[(rand() & 0xbf) + 10];
    s_Count = (s_DFB->ResX * (s_DFB->ResY - 2)) + s_DFB->ResX - 1; 
    s_Entry = s_Count + s_DFB->ResX - 1;	
    do
    {
      s_ColorMAP[s_Count] = ((s_ColorMAP[s_Count    ] + 
	                     s_ColorMAP[s_Entry    ] + 
	                     s_ColorMAP[s_Entry + 1] + 
                             s_ColorMAP[s_Entry + 2]) >> 2); 
     if(s_ColorMAP[s_Count] > 0)s_ColorMAP[s_Count]--;
     *(((unsigned short *)s_DFB->DirectMap) + s_Count) = (unsigned short)s_ColorTable[s_ColorMAP[s_Count]];
     if(s_Count < s_Limit)break;
     s_Entry--;	    
    }while(--s_Count > 0);
    s_FrameCount++;	  
    if(s_FrameCount > 128)
    {
     s_FrameCount = 0, s_ColorType++;
     if(s_ColorType >= 3)s_ColorType = 0;
    } 
    fire_load_balance();
   }while(g_break_fire == 0);
   free(s_ColorMAP);
  }
  s_DFB = MZ_DFB_Close(s_DFB);  
 }
 (void)fprintf(stdout, "End of fire.\n");
 return(0);
}

/* vim: set expandtab: */
/* End of source */ 
