/*
    Copyright (C) HWPORT.COM
    All rights reserved.
    Author: JAEHYUK CHO <mailto:minzkn@minzkn.com>
*/

#if !defined(_ISOC99_SOURCE)
# define _ISOC99_SOURCE (1L)
#endif

#if !defined(_GNU_SOURCE)
# define _GNU_SOURCE (1L)
#endif

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

int main(int s_argc, char **s_argv);

int main(int s_argc, char **s_argv)
{
    (void)s_argc;
    (void)s_argv;

    (void)fprintf(stdout, "BEGIN TEST...\n");

	do {
		pid_t s_pid;

		s_pid = fork();
		if(s_pid == ((pid_t)(-1))) {
			perror("fork");
		}
		else if(s_pid == ((pid_t)0)) {
			exit(0);
		}
		else {
			printf("make a zombie process (pid=%ld)\n", (long)s_pid);

			for(;;) { /* no waitpid call and forever exit */
				sleep(10);
			}

			/* waitpid */
		}
	}while(0);

    (void)fprintf(stdout, "END TEST...\n");

    return(EXIT_SUCCESS);
}

/* vim: set expandtab: */
/* End of source */
