/*
  Copyright (C) JAEHYUK CHO
  All rights reserved.
  Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#if !defined(__def_mzapi_mzcolor_h__)
#define __def_mzapi_mzcolor_h__ "mzcolor.h"

#if !defined(t_mzapi_dword)
typedef unsigned int t_mzapi_dword;
# define t_mzapi_dword t_mzapi_dword
#endif

#if !defined(t_mzapi_ci)
# define t_mzapi_ci t_mzapi_dword
#endif

#if !defined(t_mzapi_color)
# define t_mzapi_color t_mzapi_dword
#endif

#if !defined(mzapi_fastcall)
# define mzapi_fastcall
#endif

#if !defined(__mzapi_min__)
# define __mzapi_min__(m_left,m_right) (((m_left) < (m_right)) ? (m_left) : (m_right))
#endif

#if !defined(__mzapi_max__)
# define __mzapi_max__(m_left,m_right) (((m_left) > (m_right)) ? (m_left) : (m_right))
#endif

#if !defined(mzapi_export)
# if defined(WIN32) || defined(_WIN32)
#  define mzapi_export __declspec(dllexport)
# else
#  define mzapi_export
# endif
#endif

#if !defined(mzapi_import)
# if defined(WIN32) || defined(_WIN32)
#  define mzapi_import __declspec(dllimport) extern
# else
#  define mzapi_import extern
# endif
#endif

/* color interface define rules
 
   CI : COMMENT
   -- - ----------- 
   00 : dummy
   10 : alpha
   20 : plain  => not used this version
   30 : gray   => not used this version
   40 : red
   50 : green
   60 : blue
   70 : Y
   80 : Cb(u)
   90 : Cr(v)
   F0 : pass   => not used this version

   0xABABABAB
   A=[CI]
   B=bits
*/
#define def_mzapi_ci_none                                            ((t_mzapi_ci)0x00000000)
#define def_mzapi_ci_1bpp                                            ((t_mzapi_ci)0x00000031) /*  1 bpp */
#define def_mzapi_ci_2bpp                                            ((t_mzapi_ci)0x00002121) /*  2 bpp */
#define def_mzapi_ci_4bpp                                            ((t_mzapi_ci)0x21212121) /*  4 bpp */
#define def_mzapi_ci_8bpp                                            ((t_mzapi_ci)0x000000f8) /*  8 bpp */
#define def_mzapi_ci_rgb0233                                         ((t_mzapi_ci)0x00425363) /*  8 bpp */
#define def_mzapi_ci_rgb1555                                         ((t_mzapi_ci)0x01455565) /* 16 bpp */
#define def_mzapi_ci_rgb0565                                         ((t_mzapi_ci)0x00455665) /* 16 bpp */
#define def_mzapi_ci_rgb0888                                         ((t_mzapi_ci)0x00485868) /* 24 bpp */
#define def_mzapi_ci_rgb8888                                         ((t_mzapi_ci)0x08485868) /* 32 bpp */
#define def_mzapi_ci_argb8888                                        ((t_mzapi_ci)0x18485868) /* 32 bpp */
#define def_mzapi_ci_bgr0233                                         ((t_mzapi_ci)0x00625343) /*  8 bpp */
#define def_mzapi_ci_bgr1555                                         ((t_mzapi_ci)0x01655545) /* 16 bpp */
#define def_mzapi_ci_bgr0565                                         ((t_mzapi_ci)0x00655645) /* 16 bpp */
#define def_mzapi_ci_bgr0888                                         ((t_mzapi_ci)0x00685848) /* 24 bpp */
#define def_mzapi_ci_bgr8888                                         ((t_mzapi_ci)0x08685848) /* 32 bpp */
#define def_mzapi_ci_abgr8888                                        ((t_mzapi_ci)0x18685848) /* 32 bpp */
#define def_mzapi_ci_yuv0422                                         ((t_mzapi_ci)0x00748292) /*  8 bpp */
#define def_mzapi_ci_yuv0844                                         ((t_mzapi_ci)0x00788494) /* 16 bpp */
#define def_mzapi_ci_yuv0888                                         ((t_mzapi_ci)0x00788898) /* 24 bpp */
#define def_mzapi_ci_yuv8888                                         ((t_mzapi_ci)0x08788898) /* 32 bpp */
#define def_mzapi_ci_ayuv8888                                        ((t_mzapi_ci)0x18788898) /* 32 bpp */

struct ts_mzapi_palette { unsigned char r, g, b; };

#if !defined(__def_mzapi_mzcolor_c__)
#if 0 && defined(__cplusplus)
extern "C" {
#endif
mzapi_import char * (mzapi_fastcall mzapi_color_interface_name)(t_mzapi_ci s_color_interface);
mzapi_import t_mzapi_color (mzapi_fastcall mzapi_convert_color)(t_mzapi_ci s_to_ci, t_mzapi_ci s_from_ci, t_mzapi_color s_color);
mzapi_import struct ts_mzapi_palette g_mzapi_default_palette[], *g_mzapi_palette;
#if 0 && defined(__cplusplus)
}
#endif
#endif

#endif

/* vim: set expandtab: */
/* End of source */
