/*
  Copyright (C) JAEHYUK CHO
  All rights reserved.
  Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#if !defined(__def_mzapi_mzcolor_c__)
#define __def_mzapi_mzcolor_c__ "mzcolor.c"

#include "mzcolor.h"

#define __mzapi_cross_convert_color_from__(m_index) \
do\
{\
 s_temp = s_from_ci >> m_index;\
 s_type = s_temp & ((t_mzapi_ci)0xf0);\
 if((s_type >= ((t_mzapi_ci)0x70)) && (s_type <= ((t_mzapi_ci)0x90)))s_from_yuv = 1;\
 else if((s_type >= ((t_mzapi_ci)0x40)) && (s_type <= ((t_mzapi_ci)0x60)))s_from_yuv = 0;\
 s_bits = (int)(s_temp & ((t_mzapi_ci)0x0f));\
 s_temp_color[s_type >> 4] =\
  ((s_color >> s_bit_offset) & gc_mzapi_color_bitmask_table[s_bits - 1]) << (8 - s_bits);\
 s_bit_offset += s_bits;\
}while(0)

#define __mzapi_cross_convert_color_to__(m_index) \
do\
{\
 s_temp = s_to_ci >> m_index;\
 s_type = s_temp & ((t_mzapi_ci)0xf0);\
 s_bits = s_temp & ((t_mzapi_ci)0x0f);\
 s_result |= (s_temp_color[s_type >> 4] >> (8 - s_bits)) << s_bit_offset;\
 s_bit_offset += s_bits;\
}while(0)

mzapi_export char * (mzapi_fastcall mzapi_color_interface_name)(t_mzapi_ci s_color_interface);
mzapi_export t_mzapi_color (mzapi_fastcall mzapi_convert_color)(t_mzapi_ci s_to_ci, t_mzapi_ci s_from_ci, t_mzapi_color s_color);

mzapi_export struct ts_mzapi_palette g_mzapi_default_palette[] = {
 /*   0 */ {(unsigned char)0x00, (unsigned char)0x00, (unsigned char)0x00}, /*   0,   0,   0 */
 /*   1 */ {(unsigned char)0xff, (unsigned char)0x00, (unsigned char)0x00}, /* 255,   0,   0 */
 /*   2 */ {(unsigned char)0x00, (unsigned char)0xff, (unsigned char)0x00}, /*   0, 255,   0 */
 /*   3 */ {(unsigned char)0xda, (unsigned char)0xa5, (unsigned char)0x20}, /* 218, 165,  32 */
 /*   4 */ {(unsigned char)0xb0, (unsigned char)0xc4, (unsigned char)0xde}, /* 176, 196, 222 */
 /*   5 */ {(unsigned char)0xff, (unsigned char)0x00, (unsigned char)0xff}, /* 255,   0, 255 */
 /*   6 */ {(unsigned char)0x00, (unsigned char)0xcd, (unsigned char)0xcd}, /*   0, 205, 205 */
 /*   7 */ {(unsigned char)0xe5, (unsigned char)0xe5, (unsigned char)0xe5}, /* 229, 229, 229 */
 /*   8 */ {(unsigned char)0x4d, (unsigned char)0x4d, (unsigned char)0x4d}, /*  77,  77,  77 */
 /*   9 */ {(unsigned char)0xff, (unsigned char)0xa0, (unsigned char)0x7a}, /* 255, 160, 122 */
 /*  10 */ {(unsigned char)0x90, (unsigned char)0xee, (unsigned char)0x90}, /* 144, 238, 144 */
 /*  11 */ {(unsigned char)0xee, (unsigned char)0xdd, (unsigned char)0x82}, /* 238, 221, 130 */
 /*  12 */ {(unsigned char)0x87, (unsigned char)0xce, (unsigned char)0xfa}, /* 135, 206, 250 */
 /*  13 */ {(unsigned char)0xee, (unsigned char)0x82, (unsigned char)0xee}, /* 238, 130, 238 */
 /*  14 */ {(unsigned char)0x00, (unsigned char)0xff, (unsigned char)0xff}, /*   0, 255, 255 */
 /*  15 */ {(unsigned char)0xff, (unsigned char)0xff, (unsigned char)0xff}, /* 255, 255, 255 */
 /*  16 */ {(unsigned char)0xf0, (unsigned char)0xf8, (unsigned char)0xff}, /* 240, 248, 255 */
 /*  17 */ {(unsigned char)0xfa, (unsigned char)0xeb, (unsigned char)0xd7}, /* 250, 235, 215 */
 /*  18 */ {(unsigned char)0xcd, (unsigned char)0xc0, (unsigned char)0xb0}, /* 205, 192, 176 */
 /*  19 */ {(unsigned char)0x7f, (unsigned char)0xff, (unsigned char)0xd4}, /* 127, 255, 212 */
 /*  20 */ {(unsigned char)0x45, (unsigned char)0x8b, (unsigned char)0x74}, /*  69, 139, 116 */
 /*  21 */ {(unsigned char)0xf0, (unsigned char)0xff, (unsigned char)0xff}, /* 240, 255, 255 */
 /*  22 */ {(unsigned char)0xc1, (unsigned char)0xcd, (unsigned char)0xcd}, /* 193, 205, 205 */
 /*  23 */ {(unsigned char)0xf5, (unsigned char)0xf5, (unsigned char)0xdc}, /* 245, 245, 220 */
 /*  24 */ {(unsigned char)0xff, (unsigned char)0xe4, (unsigned char)0xc4}, /* 255, 228, 196 */
 /*  25 */ {(unsigned char)0xcd, (unsigned char)0xb7, (unsigned char)0x9e}, /* 205, 183, 158 */
 /*  26 */ {(unsigned char)0xff, (unsigned char)0xeb, (unsigned char)0xcd}, /* 255, 235, 205 */
 /*  27 */ {(unsigned char)0x8a, (unsigned char)0x2b, (unsigned char)0xe2}, /* 138,  43, 226 */
 /*  28 */ {(unsigned char)0x00, (unsigned char)0x00, (unsigned char)0xff}, /*   0,   0, 255 */
 /*  29 */ {(unsigned char)0x00, (unsigned char)0x00, (unsigned char)0xee}, /*   0,   0, 238 */
 /*  30 */ {(unsigned char)0xa5, (unsigned char)0x2a, (unsigned char)0x2a}, /* 165,  42,  42 */
 /*  31 */ {(unsigned char)0xee, (unsigned char)0x3b, (unsigned char)0x3b}, /* 238,  59,  59 */
 /*  32 */ {(unsigned char)0x8b, (unsigned char)0x23, (unsigned char)0x23}, /* 139,  35,  35 */
 /*  33 */ {(unsigned char)0xde, (unsigned char)0xb8, (unsigned char)0x87}, /* 222, 184, 135 */
 /*  34 */ {(unsigned char)0x8b, (unsigned char)0x73, (unsigned char)0x55}, /* 139, 115,  85 */
 /*  35 */ {(unsigned char)0x5f, (unsigned char)0x9e, (unsigned char)0xa0}, /*  95, 158, 160 */
 /*  36 */ {(unsigned char)0x53, (unsigned char)0x86, (unsigned char)0x8b}, /*  83, 134, 139 */
 /*  37 */ {(unsigned char)0x7f, (unsigned char)0xff, (unsigned char)0x00}, /* 127, 255,   0 */
 /*  38 */ {(unsigned char)0x45, (unsigned char)0x8b, (unsigned char)0x00}, /*  69, 139,   0 */
 /*  39 */ {(unsigned char)0xd2, (unsigned char)0x69, (unsigned char)0x1e}, /* 210, 105,  30 */
 /*  40 */ {(unsigned char)0xee, (unsigned char)0x76, (unsigned char)0x21}, /* 238, 118,  33 */
 /*  41 */ {(unsigned char)0xff, (unsigned char)0x7f, (unsigned char)0x50}, /* 255, 127,  80 */
 /*  42 */ {(unsigned char)0xee, (unsigned char)0x6a, (unsigned char)0x50}, /* 238, 106,  80 */
 /*  43 */ {(unsigned char)0x8b, (unsigned char)0x3e, (unsigned char)0x2f}, /* 139,  62,  47 */
 /*  44 */ {(unsigned char)0x64, (unsigned char)0x95, (unsigned char)0xed}, /* 100, 149, 237 */
 /*  45 */ {(unsigned char)0xff, (unsigned char)0xf8, (unsigned char)0xdc}, /* 255, 248, 220 */
 /*  46 */ {(unsigned char)0x8b, (unsigned char)0x88, (unsigned char)0x78}, /* 139, 136, 120 */
 /*  47 */ {(unsigned char)0x00, (unsigned char)0xee, (unsigned char)0xee}, /*   0, 238, 238 */
 /*  48 */ {(unsigned char)0x00, (unsigned char)0x00, (unsigned char)0x8b}, /*   0,   0, 139 */
 /*  49 */ {(unsigned char)0x00, (unsigned char)0x8b, (unsigned char)0x8b}, /*   0, 139, 139 */
 /*  50 */ {(unsigned char)0x00, (unsigned char)0x64, (unsigned char)0x00}, /*   0, 100,   0 */
 /*  51 */ {(unsigned char)0xa9, (unsigned char)0xa9, (unsigned char)0xa9}, /* 169, 169, 169 */
 /*  52 */ {(unsigned char)0xbd, (unsigned char)0xb7, (unsigned char)0x6b}, /* 189, 183, 107 */
 /*  53 */ {(unsigned char)0x8b, (unsigned char)0x00, (unsigned char)0x8b}, /* 139,   0, 139 */
 /*  54 */ {(unsigned char)0x8b, (unsigned char)0x00, (unsigned char)0x00}, /* 139,   0,   0 */
 /*  55 */ {(unsigned char)0xe9, (unsigned char)0x96, (unsigned char)0x7a}, /* 233, 150, 122 */
 /*  56 */ {(unsigned char)0x48, (unsigned char)0x3d, (unsigned char)0x8b}, /*  72,  61, 139 */
 /*  57 */ {(unsigned char)0x00, (unsigned char)0xce, (unsigned char)0xd1}, /*   0, 206, 209 */
 /*  58 */ {(unsigned char)0x94, (unsigned char)0x00, (unsigned char)0xd3}, /* 148,   0, 211 */
 /*  59 */ {(unsigned char)0xb8, (unsigned char)0x86, (unsigned char)0x0b}, /* 184, 134,  11 */
 /*  60 */ {(unsigned char)0x8b, (unsigned char)0x65, (unsigned char)0x08}, /* 139, 101,   8 */
 /*  61 */ {(unsigned char)0x55, (unsigned char)0x6b, (unsigned char)0x2f}, /*  85, 107,  47 */
 /*  62 */ {(unsigned char)0x6e, (unsigned char)0x8b, (unsigned char)0x3d}, /* 110, 139,  61 */
 /*  63 */ {(unsigned char)0xff, (unsigned char)0x8c, (unsigned char)0x00}, /* 255, 140,   0 */
 /*  64 */ {(unsigned char)0x8b, (unsigned char)0x45, (unsigned char)0x00}, /* 139,  69,   0 */
 /*  65 */ {(unsigned char)0x99, (unsigned char)0x32, (unsigned char)0xcc}, /* 153,  50, 204 */
 /*  66 */ {(unsigned char)0x68, (unsigned char)0x22, (unsigned char)0x8b}, /* 104,  34, 139 */
 /*  67 */ {(unsigned char)0x8f, (unsigned char)0xbc, (unsigned char)0x8f}, /* 143, 188, 143 */
 /*  68 */ {(unsigned char)0x69, (unsigned char)0x8b, (unsigned char)0x69}, /* 105, 139, 105 */
 /*  69 */ {(unsigned char)0x2f, (unsigned char)0x4f, (unsigned char)0x4f}, /*  47,  79,  79 */
 /*  70 */ {(unsigned char)0x52, (unsigned char)0x8b, (unsigned char)0x8b}, /*  82, 139, 139 */
 /*  71 */ {(unsigned char)0xff, (unsigned char)0x14, (unsigned char)0x93}, /* 255,  20, 147 */
 /*  72 */ {(unsigned char)0x8b, (unsigned char)0x0a, (unsigned char)0x50}, /* 139,  10,  80 */
 /*  73 */ {(unsigned char)0x00, (unsigned char)0xbf, (unsigned char)0xff}, /*   0, 191, 255 */
 /*  74 */ {(unsigned char)0x00, (unsigned char)0x68, (unsigned char)0x8b}, /*   0, 104, 139 */
 /*  75 */ {(unsigned char)0x1e, (unsigned char)0x90, (unsigned char)0xff}, /*  30, 144, 255 */
 /*  76 */ {(unsigned char)0x10, (unsigned char)0x4e, (unsigned char)0x8b}, /*  16,  78, 139 */
 /*  77 */ {(unsigned char)0xb2, (unsigned char)0x22, (unsigned char)0x22}, /* 178,  34,  34 */
 /*  78 */ {(unsigned char)0x8b, (unsigned char)0x1a, (unsigned char)0x1a}, /* 139,  26,  26 */
 /*  79 */ {(unsigned char)0xff, (unsigned char)0xfa, (unsigned char)0xf0}, /* 255, 250, 240 */
 /*  80 */ {(unsigned char)0x22, (unsigned char)0x8b, (unsigned char)0x22}, /*  34, 139,  34 */
 /*  81 */ {(unsigned char)0xdc, (unsigned char)0xdc, (unsigned char)0xdc}, /* 220, 220, 220 */
 /*  82 */ {(unsigned char)0xf8, (unsigned char)0xf8, (unsigned char)0xff}, /* 248, 248, 255 */
 /*  83 */ {(unsigned char)0xff, (unsigned char)0xd7, (unsigned char)0x00}, /* 255, 215,   0 */
 /*  84 */ {(unsigned char)0x8b, (unsigned char)0x75, (unsigned char)0x00}, /* 139, 117,   0 */
 /*  85 */ {(unsigned char)0xee, (unsigned char)0xb4, (unsigned char)0x22}, /* 238, 180,  34 */
 /*  86 */ {(unsigned char)0xcd, (unsigned char)0x9b, (unsigned char)0x1d}, /* 205, 155,  29 */
 /*  87 */ {(unsigned char)0x8b, (unsigned char)0x69, (unsigned char)0x14}, /* 139, 105,  20 */
 /*  88 */ {(unsigned char)0xad, (unsigned char)0xff, (unsigned char)0x2f}, /* 173, 255,  47 */
 /*  89 */ {(unsigned char)0x00, (unsigned char)0x8b, (unsigned char)0x00}, /*   0, 139,   0 */
 /*  90 */ {(unsigned char)0x1a, (unsigned char)0x1a, (unsigned char)0x1a}, /*  26,  26,  26 */
 /*  91 */ {(unsigned char)0xff, (unsigned char)0xff, (unsigned char)0xff}, /* 255, 255, 255 */
 /*  92 */ {(unsigned char)0x26, (unsigned char)0x26, (unsigned char)0x26}, /*  38,  38,  38 */
 /*  93 */ {(unsigned char)0x33, (unsigned char)0x33, (unsigned char)0x33}, /*  51,  51,  51 */
 /*  94 */ {(unsigned char)0x40, (unsigned char)0x40, (unsigned char)0x40}, /*  64,  64,  64 */
 /*  95 */ {(unsigned char)0x59, (unsigned char)0x59, (unsigned char)0x59}, /*  89,  89,  89 */
 /*  96 */ {(unsigned char)0x66, (unsigned char)0x66, (unsigned char)0x66}, /* 102, 102, 102 */
 /*  97 */ {(unsigned char)0x73, (unsigned char)0x73, (unsigned char)0x73}, /* 115, 115, 115 */
 /*  98 */ {(unsigned char)0x0d, (unsigned char)0x0d, (unsigned char)0x0d}, /*  13,  13,  13 */
 /*  99 */ {(unsigned char)0x7f, (unsigned char)0x7f, (unsigned char)0x7f}, /* 127, 127, 127 */
 /* 100 */ {(unsigned char)0x8c, (unsigned char)0x8c, (unsigned char)0x8c}, /* 140, 140, 140 */
 /* 101 */ {(unsigned char)0x99, (unsigned char)0x99, (unsigned char)0x99}, /* 153, 153, 153 */
 /* 102 */ {(unsigned char)0xa6, (unsigned char)0xa6, (unsigned char)0xa6}, /* 166, 166, 166 */
 /* 103 */ {(unsigned char)0xb3, (unsigned char)0xb3, (unsigned char)0xb3}, /* 179, 179, 179 */
 /* 104 */ {(unsigned char)0xbf, (unsigned char)0xbf, (unsigned char)0xbf}, /* 191, 191, 191 */
 /* 105 */ {(unsigned char)0xcc, (unsigned char)0xcc, (unsigned char)0xcc}, /* 204, 204, 204 */
 /* 106 */ {(unsigned char)0xd9, (unsigned char)0xd9, (unsigned char)0xd9}, /* 217, 217, 217 */
 /* 107 */ {(unsigned char)0xf2, (unsigned char)0xf2, (unsigned char)0xf2}, /* 242, 242, 242 */
 /* 108 */ {(unsigned char)0xf0, (unsigned char)0xff, (unsigned char)0xf0}, /* 240, 255, 240 */
 /* 109 */ {(unsigned char)0x83, (unsigned char)0x8b, (unsigned char)0x83}, /* 131, 139, 131 */
 /* 110 */ {(unsigned char)0xff, (unsigned char)0x69, (unsigned char)0xb4}, /* 255, 105, 180 */
 /* 111 */ {(unsigned char)0x8b, (unsigned char)0x3a, (unsigned char)0x62}, /* 139,  58,  98 */
 /* 112 */ {(unsigned char)0xcd, (unsigned char)0x5c, (unsigned char)0x5c}, /* 205,  92,  92 */
 /* 113 */ {(unsigned char)0x8b, (unsigned char)0x3a, (unsigned char)0x3a}, /* 139,  58,  58 */
 /* 114 */ {(unsigned char)0xff, (unsigned char)0xff, (unsigned char)0xf0}, /* 255, 255, 240 */
 /* 115 */ {(unsigned char)0x8b, (unsigned char)0x8b, (unsigned char)0x83}, /* 139, 139, 131 */
 /* 116 */ {(unsigned char)0xf0, (unsigned char)0xe6, (unsigned char)0x8c}, /* 240, 230, 140 */
 /* 117 */ {(unsigned char)0x8b, (unsigned char)0x86, (unsigned char)0x4e}, /* 139, 134,  78 */
 /* 118 */ {(unsigned char)0xe6, (unsigned char)0xe6, (unsigned char)0xfa}, /* 230, 230, 250 */
 /* 119 */ {(unsigned char)0xff, (unsigned char)0xf0, (unsigned char)0xf5}, /* 255, 240, 245 */
 /* 120 */ {(unsigned char)0x8b, (unsigned char)0x83, (unsigned char)0x86}, /* 139, 131, 134 */
 /* 121 */ {(unsigned char)0x7c, (unsigned char)0xfc, (unsigned char)0x00}, /* 124, 252,   0 */
 /* 122 */ {(unsigned char)0xff, (unsigned char)0xfa, (unsigned char)0xcd}, /* 255, 250, 205 */
 /* 123 */ {(unsigned char)0x8b, (unsigned char)0x89, (unsigned char)0x70}, /* 139, 137, 112 */
 /* 124 */ {(unsigned char)0xf0, (unsigned char)0x80, (unsigned char)0x80}, /* 240, 128, 128 */
 /* 125 */ {(unsigned char)0xfa, (unsigned char)0xfa, (unsigned char)0xd2}, /* 250, 250, 210 */
 /* 126 */ {(unsigned char)0xd3, (unsigned char)0xd3, (unsigned char)0xd3}, /* 211, 211, 211 */
 /* 127 */ {(unsigned char)0x20, (unsigned char)0xb2, (unsigned char)0xaa}, /*  32, 178, 170 */
 /* 128 */ {(unsigned char)0x77, (unsigned char)0x88, (unsigned char)0x99}, /* 119, 136, 153 */
 /* 129 */ {(unsigned char)0xad, (unsigned char)0xd8, (unsigned char)0xe6}, /* 173, 216, 230 */
 /* 130 */ {(unsigned char)0x68, (unsigned char)0x83, (unsigned char)0x8b}, /* 104, 131, 139 */
 /* 131 */ {(unsigned char)0xe0, (unsigned char)0xff, (unsigned char)0xff}, /* 224, 255, 255 */
 /* 132 */ {(unsigned char)0x7a, (unsigned char)0x8b, (unsigned char)0x8b}, /* 122, 139, 139 */
 /* 133 */ {(unsigned char)0xee, (unsigned char)0xdc, (unsigned char)0x82}, /* 238, 220, 130 */
 /* 134 */ {(unsigned char)0xcd, (unsigned char)0xbe, (unsigned char)0x70}, /* 205, 190, 112 */
 /* 135 */ {(unsigned char)0x8b, (unsigned char)0x81, (unsigned char)0x4c}, /* 139, 129,  76 */
 /* 136 */ {(unsigned char)0xff, (unsigned char)0xb6, (unsigned char)0xc1}, /* 255, 182, 193 */
 /* 137 */ {(unsigned char)0x8b, (unsigned char)0x5f, (unsigned char)0x65}, /* 139,  95, 101 */
 /* 138 */ {(unsigned char)0x8b, (unsigned char)0x57, (unsigned char)0x42}, /* 139,  87,  66 */
 /* 139 */ {(unsigned char)0x60, (unsigned char)0x7b, (unsigned char)0x8b}, /*  96, 123, 139 */
 /* 140 */ {(unsigned char)0x84, (unsigned char)0x70, (unsigned char)0xff}, /* 132, 112, 255 */
 /* 141 */ {(unsigned char)0x6e, (unsigned char)0x7b, (unsigned char)0x8b}, /* 110, 123, 139 */
 /* 142 */ {(unsigned char)0xff, (unsigned char)0xff, (unsigned char)0xe0}, /* 255, 255, 224 */
 /* 143 */ {(unsigned char)0x8b, (unsigned char)0x8b, (unsigned char)0x7a}, /* 139, 139, 122 */
 /* 144 */ {(unsigned char)0x32, (unsigned char)0xcd, (unsigned char)0x32}, /*  50, 205,  50 */
 /* 145 */ {(unsigned char)0xfa, (unsigned char)0xf0, (unsigned char)0xe6}, /* 250, 240, 230 */
 /* 146 */ {(unsigned char)0xee, (unsigned char)0x00, (unsigned char)0xee}, /* 238,   0, 238 */
 /* 147 */ {(unsigned char)0xb0, (unsigned char)0x30, (unsigned char)0x60}, /* 176,  48,  96 */
 /* 148 */ {(unsigned char)0x8b, (unsigned char)0x1c, (unsigned char)0x62}, /* 139,  28,  98 */
 /* 149 */ {(unsigned char)0x66, (unsigned char)0xcd, (unsigned char)0xaa}, /* 102, 205, 170 */
 /* 150 */ {(unsigned char)0x00, (unsigned char)0x00, (unsigned char)0xcd}, /*   0,   0, 205 */
 /* 151 */ {(unsigned char)0x3c, (unsigned char)0xb3, (unsigned char)0x71}, /*  60, 179, 113 */
 /* 152 */ {(unsigned char)0x7b, (unsigned char)0x68, (unsigned char)0xee}, /* 123, 104, 238 */
 /* 153 */ {(unsigned char)0x00, (unsigned char)0xfa, (unsigned char)0x9a}, /*   0, 250, 154 */
 /* 154 */ {(unsigned char)0x48, (unsigned char)0xd1, (unsigned char)0xcc}, /*  72, 209, 204 */
 /* 155 */ {(unsigned char)0xc7, (unsigned char)0x15, (unsigned char)0x85}, /* 199,  21, 133 */
 /* 156 */ {(unsigned char)0xba, (unsigned char)0x55, (unsigned char)0xd3}, /* 186,  85, 211 */
 /* 157 */ {(unsigned char)0x7a, (unsigned char)0x37, (unsigned char)0x8b}, /* 122,  55, 139 */
 /* 158 */ {(unsigned char)0x93, (unsigned char)0x70, (unsigned char)0xdb}, /* 147, 112, 219 */
 /* 159 */ {(unsigned char)0x5d, (unsigned char)0x47, (unsigned char)0x8b}, /*  93,  71, 139 */
 /* 160 */ {(unsigned char)0x19, (unsigned char)0x19, (unsigned char)0x70}, /*  25,  25, 112 */
 /* 161 */ {(unsigned char)0xf5, (unsigned char)0xff, (unsigned char)0xfa}, /* 245, 255, 250 */
 /* 162 */ {(unsigned char)0xff, (unsigned char)0xe4, (unsigned char)0xe1}, /* 255, 228, 225 */
 /* 163 */ {(unsigned char)0x8b, (unsigned char)0x7d, (unsigned char)0x7b}, /* 139, 125, 123 */
 /* 164 */ {(unsigned char)0xff, (unsigned char)0xe4, (unsigned char)0xb5}, /* 255, 228, 181 */
 /* 165 */ {(unsigned char)0xff, (unsigned char)0xde, (unsigned char)0xad}, /* 255, 222, 173 */
 /* 166 */ {(unsigned char)0x8b, (unsigned char)0x79, (unsigned char)0x5e}, /* 139, 121,  94 */
 /* 167 */ {(unsigned char)0x00, (unsigned char)0x00, (unsigned char)0x80}, /*   0,   0, 128 */
 /* 168 */ {(unsigned char)0xfd, (unsigned char)0xf5, (unsigned char)0xe6}, /* 253, 245, 230 */
 /* 169 */ {(unsigned char)0x6b, (unsigned char)0x8e, (unsigned char)0x23}, /* 107, 142,  35 */
 /* 170 */ {(unsigned char)0x69, (unsigned char)0x8b, (unsigned char)0x22}, /* 105, 139,  34 */
 /* 171 */ {(unsigned char)0xff, (unsigned char)0xa5, (unsigned char)0x00}, /* 255, 165,   0 */
 /* 172 */ {(unsigned char)0x8b, (unsigned char)0x5a, (unsigned char)0x00}, /* 139,  90,   0 */
 /* 173 */ {(unsigned char)0xff, (unsigned char)0x45, (unsigned char)0x00}, /* 255,  69,   0 */
 /* 174 */ {(unsigned char)0x8b, (unsigned char)0x25, (unsigned char)0x00}, /* 139,  37,   0 */
 /* 175 */ {(unsigned char)0xda, (unsigned char)0x70, (unsigned char)0xd6}, /* 218, 112, 214 */
 /* 176 */ {(unsigned char)0x8b, (unsigned char)0x47, (unsigned char)0x89}, /* 139,  71, 137 */
 /* 177 */ {(unsigned char)0xee, (unsigned char)0xe8, (unsigned char)0xaa}, /* 238, 232, 170 */
 /* 178 */ {(unsigned char)0x98, (unsigned char)0xfb, (unsigned char)0x98}, /* 152, 251, 152 */
 /* 179 */ {(unsigned char)0x54, (unsigned char)0x8b, (unsigned char)0x54}, /*  84, 139,  84 */
 /* 180 */ {(unsigned char)0xaf, (unsigned char)0xee, (unsigned char)0xee}, /* 175, 238, 238 */
 /* 181 */ {(unsigned char)0x66, (unsigned char)0x8b, (unsigned char)0x8b}, /* 102, 139, 139 */
 /* 182 */ {(unsigned char)0xdb, (unsigned char)0x70, (unsigned char)0x93}, /* 219, 112, 147 */
 /* 183 */ {(unsigned char)0xee, (unsigned char)0x79, (unsigned char)0x9f}, /* 238, 121, 159 */
 /* 184 */ {(unsigned char)0x8b, (unsigned char)0x47, (unsigned char)0x5d}, /* 139,  71,  93 */
 /* 185 */ {(unsigned char)0xff, (unsigned char)0xef, (unsigned char)0xd5}, /* 255, 239, 213 */
 /* 186 */ {(unsigned char)0xff, (unsigned char)0xda, (unsigned char)0xb9}, /* 255, 218, 185 */
 /* 187 */ {(unsigned char)0x8b, (unsigned char)0x77, (unsigned char)0x65}, /* 139, 119, 101 */
 /* 188 */ {(unsigned char)0xff, (unsigned char)0xc0, (unsigned char)0xcb}, /* 255, 192, 203 */
 /* 189 */ {(unsigned char)0x8b, (unsigned char)0x63, (unsigned char)0x6c}, /* 139,  99, 108 */
 /* 190 */ {(unsigned char)0xdd, (unsigned char)0xa0, (unsigned char)0xdd}, /* 221, 160, 221 */
 /* 191 */ {(unsigned char)0xee, (unsigned char)0xae, (unsigned char)0xee}, /* 238, 174, 238 */
 /* 192 */ {(unsigned char)0x8b, (unsigned char)0x66, (unsigned char)0x8b}, /* 139, 102, 139 */
 /* 193 */ {(unsigned char)0xb0, (unsigned char)0xe0, (unsigned char)0xe6}, /* 176, 224, 230 */
 /* 194 */ {(unsigned char)0xa0, (unsigned char)0x20, (unsigned char)0xf0}, /* 160,  32, 240 */
 /* 195 */ {(unsigned char)0x91, (unsigned char)0x2c, (unsigned char)0xee}, /* 145,  44, 238 */
 /* 196 */ {(unsigned char)0x55, (unsigned char)0x1a, (unsigned char)0x8b}, /*  85,  26, 139 */
 /* 197 */ {(unsigned char)0xff, (unsigned char)0x00, (unsigned char)0x00}, /* 255,   0,   0 */
 /* 198 */ {(unsigned char)0xcd, (unsigned char)0x00, (unsigned char)0x00}, /* 205,   0,   0 */
 /* 199 */ {(unsigned char)0xbc, (unsigned char)0x8f, (unsigned char)0x8f}, /* 188, 143, 143 */
 /* 200 */ {(unsigned char)0xee, (unsigned char)0xb4, (unsigned char)0xb4}, /* 238, 180, 180 */
 /* 201 */ {(unsigned char)0x8b, (unsigned char)0x69, (unsigned char)0x69}, /* 139, 105, 105 */
 /* 202 */ {(unsigned char)0x41, (unsigned char)0x69, (unsigned char)0xe1}, /*  65, 105, 225 */
 /* 203 */ {(unsigned char)0x43, (unsigned char)0x6e, (unsigned char)0xee}, /*  67, 110, 238 */
 /* 204 */ {(unsigned char)0x27, (unsigned char)0x40, (unsigned char)0x8b}, /*  39,  64, 139 */
 /* 205 */ {(unsigned char)0x8b, (unsigned char)0x45, (unsigned char)0x13}, /* 139,  69,  19 */
 /* 206 */ {(unsigned char)0xfa, (unsigned char)0x80, (unsigned char)0x72}, /* 250, 128, 114 */
 /* 207 */ {(unsigned char)0xee, (unsigned char)0x82, (unsigned char)0x62}, /* 238, 130,  98 */
 /* 208 */ {(unsigned char)0x8b, (unsigned char)0x4c, (unsigned char)0x39}, /* 139,  76,  57 */
 /* 209 */ {(unsigned char)0xf4, (unsigned char)0xa4, (unsigned char)0x60}, /* 244, 164,  96 */
 /* 210 */ {(unsigned char)0x2e, (unsigned char)0x8b, (unsigned char)0x57}, /*  46, 139,  87 */
 /* 211 */ {(unsigned char)0x4e, (unsigned char)0xee, (unsigned char)0x94}, /*  78, 238, 148 */
 /* 212 */ {(unsigned char)0xff, (unsigned char)0xf5, (unsigned char)0xee}, /* 255, 245, 238 */
 /* 213 */ {(unsigned char)0x8b, (unsigned char)0x86, (unsigned char)0x82}, /* 139, 134, 130 */
 /* 214 */ {(unsigned char)0xa0, (unsigned char)0x52, (unsigned char)0x2d}, /* 160,  82,  45 */
 /* 215 */ {(unsigned char)0x8b, (unsigned char)0x47, (unsigned char)0x26}, /* 139,  71,  38 */
 /* 216 */ {(unsigned char)0x87, (unsigned char)0xce, (unsigned char)0xeb}, /* 135, 206, 235 */
 /* 217 */ {(unsigned char)0x4a, (unsigned char)0x70, (unsigned char)0x8b}, /*  74, 112, 139 */
 /* 218 */ {(unsigned char)0x6a, (unsigned char)0x5a, (unsigned char)0xcd}, /* 106,  90, 205 */
 /* 219 */ {(unsigned char)0x7a, (unsigned char)0x67, (unsigned char)0xee}, /* 122, 103, 238 */
 /* 220 */ {(unsigned char)0x47, (unsigned char)0x3c, (unsigned char)0x8b}, /*  71,  60, 139 */
 /* 221 */ {(unsigned char)0x70, (unsigned char)0x80, (unsigned char)0x90}, /* 112, 128, 144 */
 /* 222 */ {(unsigned char)0xb9, (unsigned char)0xd3, (unsigned char)0xee}, /* 185, 211, 238 */
 /* 223 */ {(unsigned char)0x6c, (unsigned char)0x7b, (unsigned char)0x8b}, /* 108, 123, 139 */
 /* 224 */ {(unsigned char)0xff, (unsigned char)0xfa, (unsigned char)0xfa}, /* 255, 250, 250 */
 /* 225 */ {(unsigned char)0xee, (unsigned char)0xe9, (unsigned char)0xe9}, /* 238, 233, 233 */
 /* 226 */ {(unsigned char)0x8b, (unsigned char)0x89, (unsigned char)0x89}, /* 139, 137, 137 */
 /* 227 */ {(unsigned char)0x00, (unsigned char)0xff, (unsigned char)0x7f}, /*   0, 255, 127 */
 /* 228 */ {(unsigned char)0x00, (unsigned char)0xee, (unsigned char)0x76}, /*   0, 238, 118 */
 /* 229 */ {(unsigned char)0x00, (unsigned char)0x8b, (unsigned char)0x45}, /*   0, 139,  69 */
 /* 230 */ {(unsigned char)0x46, (unsigned char)0x82, (unsigned char)0xb4}, /*  70, 130, 180 */
 /* 231 */ {(unsigned char)0x5c, (unsigned char)0xac, (unsigned char)0xee}, /*  92, 172, 238 */
 /* 232 */ {(unsigned char)0x36, (unsigned char)0x64, (unsigned char)0x8b}, /*  54, 100, 139 */
 /* 233 */ {(unsigned char)0xd2, (unsigned char)0xb4, (unsigned char)0x8c}, /* 210, 180, 140 */
 /* 234 */ {(unsigned char)0xee, (unsigned char)0x9a, (unsigned char)0x49}, /* 238, 154,  73 */
 /* 235 */ {(unsigned char)0x8b, (unsigned char)0x5a, (unsigned char)0x2b}, /* 139,  90,  43 */
 /* 236 */ {(unsigned char)0xd8, (unsigned char)0xbf, (unsigned char)0xd8}, /* 216, 191, 216 */
 /* 237 */ {(unsigned char)0xee, (unsigned char)0xd2, (unsigned char)0xee}, /* 238, 210, 238 */
 /* 238 */ {(unsigned char)0x8b, (unsigned char)0x7b, (unsigned char)0x8b}, /* 139, 123, 139 */
 /* 239 */ {(unsigned char)0xff, (unsigned char)0x63, (unsigned char)0x47}, /* 255,  99,  71 */
 /* 240 */ {(unsigned char)0xee, (unsigned char)0x5c, (unsigned char)0x42}, /* 238,  92,  66 */
 /* 241 */ {(unsigned char)0x8b, (unsigned char)0x36, (unsigned char)0x26}, /* 139,  54,  38 */
 /* 242 */ {(unsigned char)0x40, (unsigned char)0xe0, (unsigned char)0xd0}, /*  64, 224, 208 */
 /* 243 */ {(unsigned char)0x00, (unsigned char)0xe5, (unsigned char)0xee}, /*   0, 229, 238 */
 /* 244 */ {(unsigned char)0x00, (unsigned char)0x86, (unsigned char)0x8b}, /*   0, 134, 139 */
 /* 245 */ {(unsigned char)0xd0, (unsigned char)0x20, (unsigned char)0x90}, /* 208,  32, 144 */
 /* 246 */ {(unsigned char)0xee, (unsigned char)0x3a, (unsigned char)0x8c}, /* 238,  58, 140 */
 /* 247 */ {(unsigned char)0x8b, (unsigned char)0x22, (unsigned char)0x52}, /* 139,  34,  82 */
 /* 248 */ {(unsigned char)0xff, (unsigned char)0xe7, (unsigned char)0xba}, /* 255, 231, 186 */
 /* 249 */ {(unsigned char)0xee, (unsigned char)0xd8, (unsigned char)0xae}, /* 238, 216, 174 */
 /* 250 */ {(unsigned char)0xcd, (unsigned char)0xba, (unsigned char)0x96}, /* 205, 186, 150 */
 /* 251 */ {(unsigned char)0x8b, (unsigned char)0x7e, (unsigned char)0x66}, /* 139, 126, 102 */
 /* 252 */ {(unsigned char)0x9a, (unsigned char)0xcd, (unsigned char)0x32}, /* 154, 205,  50 */
 /* 253 */ {(unsigned char)0xff, (unsigned char)0xff, (unsigned char)0x00}, /* 255, 255,   0 */
 /* 254 */ {(unsigned char)0xee, (unsigned char)0xee, (unsigned char)0x00}, /* 238, 238,   0 */
 /* 255 */ {(unsigned char)0x8b, (unsigned char)0x8b, (unsigned char)0x00}  /* 139, 139,   0 */
}, *g_mzapi_palette = (struct ts_mzapi_palette *)(&g_mzapi_default_palette[0]);
 
static const t_mzapi_color gc_mzapi_color_bitmask_table[] = {
 (t_mzapi_color)0x00000001, (t_mzapi_color)0x00000003, (t_mzapi_color)0x00000007, (t_mzapi_color)0x0000000f, 
 (t_mzapi_color)0x0000001f, (t_mzapi_color)0x0000003f, (t_mzapi_color)0x0000007f, (t_mzapi_color)0x000000ff, 
 (t_mzapi_color)0x000001ff, (t_mzapi_color)0x000003ff, (t_mzapi_color)0x000007ff, (t_mzapi_color)0x00000fff, 
 (t_mzapi_color)0x00001fff, (t_mzapi_color)0x00003fff, (t_mzapi_color)0x00007fff, (t_mzapi_color)0x0000ffff, 
 (t_mzapi_color)0x0001ffff, (t_mzapi_color)0x0003ffff, (t_mzapi_color)0x0007ffff, (t_mzapi_color)0x000fffff, 
 (t_mzapi_color)0x001fffff, (t_mzapi_color)0x003fffff, (t_mzapi_color)0x007fffff, (t_mzapi_color)0x00ffffff, 
 (t_mzapi_color)0x01ffffff, (t_mzapi_color)0x03ffffff, (t_mzapi_color)0x07ffffff, (t_mzapi_color)0x0fffffff, 
 (t_mzapi_color)0x1fffffff, (t_mzapi_color)0x3fffffff, (t_mzapi_color)0x7fffffff, (t_mzapi_color)0xffffffff
};

char * (mzapi_fastcall mzapi_color_interface_name)(t_mzapi_ci s_color_interface)
{
 static char s_name[ 8 /* try thread safe : 8 level */ ][ 16 ];
 static int s_name_cache = 0;
 int s_offset = 0, s_index, s_bit;
 if(s_name_cache >= 8)s_name_cache = 0;
 for(s_index = 24;s_index >= 0;s_index -= 8)
 {
  switch((s_color_interface >> s_index) & ((t_mzapi_ci)0xf0))
  {
   case 0x00: s_name[s_name_cache][s_offset++] = 'd'; break;
   case 0x10: s_name[s_name_cache][s_offset++] = 'A'; break;
   case 0x20: s_name[s_name_cache][s_offset++] = 'P'; break;
   case 0x30: s_name[s_name_cache][s_offset++] = 'g'; break;
   case 0x40: s_name[s_name_cache][s_offset++] = 'R'; break;
   case 0x50: s_name[s_name_cache][s_offset++] = 'G'; break;
   case 0x60: s_name[s_name_cache][s_offset++] = 'B'; break;
   case 0x70: s_name[s_name_cache][s_offset++] = 'Y'; break;
   case 0x80: s_name[s_name_cache][s_offset++] = 'u'; break;
   case 0x90: s_name[s_name_cache][s_offset++] = 'v'; break;
   case 0xf0: s_name[s_name_cache][s_offset++] = 'p'; break;
   default:   s_name[s_name_cache][s_offset++] = 'x'; break;
  }
 }
 for(s_index = 24;s_index >= 0;s_index -= 8)
 {
  s_bit = (s_color_interface >> s_index) & ((t_mzapi_ci)0x0f);
  s_bit += (s_bit < 0x0a) ? '0' : 'A';
  s_name[s_name_cache][s_offset++] = s_bit;
 }
 s_name[s_name_cache][s_offset] = '\0';
 return((char *)(&s_name[s_name_cache++][0]));
}

t_mzapi_color (mzapi_fastcall mzapi_convert_color)(t_mzapi_ci s_to_ci, t_mzapi_ci s_from_ci, t_mzapi_color s_color)
{
 t_mzapi_color s_result, s_temp_color[ 16 ];
 int s_bit_offset, s_bits, s_from_yuv, s_r, s_g, s_b, s_y, s_u, s_v;
 t_mzapi_ci s_type, s_temp;
 if(s_to_ci == s_from_ci)return(s_color);
 s_from_yuv = (-1);
 for(s_bit_offset = 0;s_bit_offset < 16;s_bit_offset++)s_temp_color[s_bit_offset] = (t_mzapi_color)0;
 if(s_from_ci == def_mzapi_ci_1bpp)
 {
  if(s_color != ((t_mzapi_color)0))
  {
   s_temp_color[0x40 >> 4] = (t_mzapi_color)g_mzapi_palette[15].r;
   s_temp_color[0x50 >> 4] = (t_mzapi_color)g_mzapi_palette[15].g;
   s_temp_color[0x60 >> 4] = (t_mzapi_color)g_mzapi_palette[15].b;
  }
 }
 else if((s_from_ci == def_mzapi_ci_4bpp) || (s_from_ci == def_mzapi_ci_4bpp) || (s_from_ci == def_mzapi_ci_8bpp))
 {
  s_temp_color[0x40 >> 4] = (t_mzapi_color)g_mzapi_palette[s_color].r;
  s_temp_color[0x50 >> 4] = (t_mzapi_color)g_mzapi_palette[s_color].g;
  s_temp_color[0x60 >> 4] = (t_mzapi_color)g_mzapi_palette[s_color].b;
 }
 else
 {
  s_bit_offset = 0;
  __mzapi_cross_convert_color_from__(0);
  __mzapi_cross_convert_color_from__(8);
  __mzapi_cross_convert_color_from__(16);
  __mzapi_cross_convert_color_from__(24);
 }
 if(s_from_yuv == 0)
 {
  s_r = (int)s_temp_color[0x40 >> 4];
  s_g = (int)s_temp_color[0x50 >> 4];
  s_b = (int)s_temp_color[0x60 >> 4];
  s_y =  ((19595 * s_r) >> 16) + ((38470 * s_g) >> 16) + ((7471  * s_b) >> 16);
  s_u = -((11059 * s_r) >> 16) - ((21709 * s_g) >> 16) + ((32768 * s_b) >> 16) + 128;
  s_v =  ((32768 * s_r) >> 16) - ((27439 * s_g) >> 16) - ((5329  * s_b) >> 16) + 128;
  s_temp_color[0x70 >> 4] = (t_mzapi_color)__mzapi_min__(__mzapi_max__(s_y, 0), 255);
  s_temp_color[0x80 >> 4] = (t_mzapi_color)__mzapi_min__(__mzapi_max__(s_u, 0), 255);
  s_temp_color[0x90 >> 4] = (t_mzapi_color)__mzapi_min__(__mzapi_max__(s_v, 0), 255);
 }
 else if(s_from_yuv == 1)
 {
  s_y = (int)s_temp_color[0x70 >> 4];
  s_u = ((int)s_temp_color[0x80 >> 4]) - 128;
  s_v = ((int)s_temp_color[0x90 >> 4]) - 128;
  s_temp_color[0x40 >> 4] = (t_mzapi_color)(s_y + ((91881  * s_v) / 65536));
  s_temp_color[0x50 >> 4] = (t_mzapi_color)(s_y - ((22554  * s_u) / 65536) - ((46802 * s_v) / 65536));
  s_temp_color[0x60 >> 4] = (t_mzapi_color)(s_y + ((116130 * s_y) / 65536));
 }
 s_result = (t_mzapi_color)0;
 s_bit_offset = 0;
 __mzapi_cross_convert_color_to__(0);
 __mzapi_cross_convert_color_to__(8);
 __mzapi_cross_convert_color_to__(16);
 __mzapi_cross_convert_color_to__(24);
 return(s_result);
}

#endif

/* vim: set expandtab: */
/* End of source */
