/*
  Copyright (C) JAEHYUK CHO
  All rights reserved.
  Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#include <stdio.h>

#include "mzcolor.h"

#if defined(WIN32) || defined(_WIN32)
# define test(m_to_ci,m_from_ci,m_color) \
do{ \
 s_from_ci = m_from_ci, s_to_ci = m_to_ci, s_color = (t_mzapi_color)m_color; \
 s_result  = mzapi_convert_color(s_to_ci, s_from_ci, s_color); \
 (void)fprintf(stdout, "%s(%08lXH) <- %s(%08lXH)\n", \
  mzapi_color_interface_name(s_to_ci), (unsigned long)s_result, \
  mzapi_color_interface_name(s_from_ci), (unsigned long)s_color); \
}while(0)
#else
# define test(m_to_ci,m_from_ci,m_color) \
do{ \
 s_from_ci = m_from_ci, s_to_ci = m_to_ci, s_color = (t_mzapi_color)m_color; \
 s_result  = mzapi_convert_color(s_to_ci, s_from_ci, s_color); \
 (void)fprintf(stdout, "%s(\x1b[1;32m%08lXH\x1b[0m) <- %s(\x1b[1;32m%08lXH\x1b[0m)\n", \
  mzapi_color_interface_name(s_to_ci), (unsigned long)s_result, \
  mzapi_color_interface_name(s_from_ci), (unsigned long)s_color); \
}while(0)
#endif

#define test_pattern(m_to_ci,m_from_ci) \
do{ \
 test(m_to_ci, m_from_ci, mzapi_convert_color(s_from_ci, def_mzapi_ci_rgb0888, 0x00000400)); /* white */ \
 test(m_to_ci, m_from_ci, mzapi_convert_color(s_from_ci, def_mzapi_ci_rgb0888, 0x00ffffff)); /* white */ \
 test(m_to_ci, m_from_ci, mzapi_convert_color(s_from_ci, def_mzapi_ci_rgb0888, 0x007f7f7f)); /* gray  */ \
 test(m_to_ci, m_from_ci, mzapi_convert_color(s_from_ci, def_mzapi_ci_rgb0888, 0x00000000)); /* black */ \
 test(m_to_ci, m_from_ci, mzapi_convert_color(s_from_ci, def_mzapi_ci_rgb0888, 0x00ff0000)); /* red   */ \
 test(m_to_ci, m_from_ci, mzapi_convert_color(s_from_ci, def_mzapi_ci_rgb0888, 0x0000ff00)); /* green */ \
 test(m_to_ci, m_from_ci, mzapi_convert_color(s_from_ci, def_mzapi_ci_rgb0888, 0x000000ff)); /* blue  */ \
}while(0)

#define hr() (void)fprintf(stdout, "------------------------------------------\n");

int (main)(int s_argc, char **s_argv)
{
 t_mzapi_ci s_to_ci, s_from_ci;
 t_mzapi_color s_color, s_result;

 hr();
 
 /* 888 base */ 
 test_pattern(def_mzapi_ci_rgb0888, def_mzapi_ci_rgb0888); 
 test_pattern(def_mzapi_ci_rgb0565, def_mzapi_ci_rgb0888); 
 test_pattern(def_mzapi_ci_rgb1555, def_mzapi_ci_rgb0888); 
 test_pattern(def_mzapi_ci_yuv0888, def_mzapi_ci_rgb0888); 
 test_pattern(def_mzapi_ci_yuv0844, def_mzapi_ci_rgb0888); 
 test_pattern(def_mzapi_ci_yuv0422, def_mzapi_ci_rgb0888); 

 hr();

 /* 565 base */
 test_pattern(def_mzapi_ci_rgb0888, def_mzapi_ci_rgb0565); 
 test_pattern(def_mzapi_ci_rgb0565, def_mzapi_ci_rgb0565); 
 test_pattern(def_mzapi_ci_rgb1555, def_mzapi_ci_rgb0565); 
 test_pattern(def_mzapi_ci_yuv0888, def_mzapi_ci_rgb0565); 
 test_pattern(def_mzapi_ci_yuv0844, def_mzapi_ci_rgb0565); 
 test_pattern(def_mzapi_ci_yuv0422, def_mzapi_ci_rgb0565); 

 hr();

 return(0);
}

/* vim: set expandtab: */
/* End of source */
