/*
 Copyright (C) JAEHYUK CHO
 All rights reserved.
 Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>

 http://www.minzkn.com
*/

#include <stdio.h>
#include <memory.h>
#include <malloc.h>

#include "font_en.h"
#include "font_ko.h"
#include "ks_table.h"

struct ts_vfb
{ /* simple virtual frame buffer : VeryVeryVeryVVVV.... simple define */
 int bpp, resx, resy, line_length, shadow;
 size_t map_size;
 void *map;
};

static void  mz_convert_ks_to_johab(unsigned short *s_code)
{
 unsigned short s_high, s_low;
 s_high = (*(s_code)     ) & 0xff; 
 s_low  = (*(s_code) >> 8) & 0xff;
 if(((s_low < 0xb0) && (s_low > 0xc8)) || ((s_high < 0xa1) && (s_high > 0xfe)))*(s_code) = 0x2020;
 else if(s_low == 0xa4)
 {
  if((s_high >= 0xa1) && (s_high <= 0xd3))*(s_code) = g_mz_ks_table_single[s_high - 0xa1]; 
  else *(s_code) = 0x2020;
 }
 else *(s_code) = g_mz_ks_table[((s_low - 0xb0) * 94) + (s_high - 0xa1)];  
}

static void mz_get_bitmap_johab(void *s_bitmap, int s_code)
{
 static const unsigned char cg_hangul_table[3][32] = {
  {0x07, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 
   0x10, 0x11, 0x12, 0xff, 0x09, 0x0b, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
  {0xff, 0xff, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0xff, 0xff, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0xff, 0xff, 
   0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0xff, 0xff, 0x11, 0x12, 0x13, 0x14, 0x00, 0x01}, 
  {0xff, 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 
   0xff, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x14, 0x14}
 };
 static const unsigned char cg_hangul_table_f[2][21] = {
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x03, 0x03, 0x01, 0x02, 0x04, 0x04, 0x04, 0x02, 
   0x01, 0x03, 0x00}, 
  {0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x06, 0x07, 0x07, 0x07, 0x06, 0x06, 0x07, 0x07, 0x07, 0x06, 
   0x06, 0x07, 0x05}
 };
 static const unsigned char cg_hangul_table_l[21] = {
  0x00, 0x02, 0x00, 0x02, 0x01, 0x02, 0x01, 0x02, 0x03, 0x00, 0x02, 0x01, 0x03, 0x03, 0x01, 0x02, 0x01, 0x03, 
  0x03, 0x01, 0x01
 }; 
 unsigned short s_c0, s_c1, s_c2, s_b0, s_b1, s_b2, s_count;
 unsigned char *s_buffer = (unsigned char *)s_bitmap;
 int s_index;
 s_code &= 0xffff;
 s_c0 = (unsigned short)cg_hangul_table[0][(s_code >> 0x0a) & 0x1f] & 0xff;
 s_c1 = (unsigned short)cg_hangul_table[1][(s_code >> 0x05) & 0x1f] & 0xff;
 s_c2 = (unsigned short)cg_hangul_table[2][(s_code        ) & 0x1f] & 0xff;
 if(s_c2 == 0x00ff)
 {
  s_b0 = (unsigned short)cg_hangul_table_f[0][s_c1];
  if((s_c0 == 0) || (s_c0 == 0x000f))s_b1 = 0;
  else s_b1 = 1;                              
  s_b2 = 0;  
 }
 else
 {
  s_b0 = (unsigned short)cg_hangul_table_f[1][s_c1];
  if((s_c0 == 0) || (s_c0 == 0x000f))s_b1 = 2;
  else s_b1 = 3;
  s_b2 = (unsigned short)cg_hangul_table_l[s_c1];
 }
 (void)memset(s_buffer, 0, (size_t)32);
 for(s_count = 0;s_count < 32;s_count+=2)
 {
  if(s_c0 != 0xff)
  {
   s_index = (s_b0 * 19 * 32) + (s_c0 * 32) + (s_count) + 0;
   if(s_index < 11008)
   {
    s_buffer[s_count] |= g_mz_bitmap_font_ko[s_index];
    s_buffer[s_count + 1] |= g_mz_bitmap_font_ko[s_index + 1];
   }
  }
  if(s_c1 != 0xff)
  {
   s_index = (s_b1 * 21 * 32) + (s_c1 * 32) + (s_count) + 4864;
   if(s_index < 11008)
   {
    s_buffer[s_count] |= g_mz_bitmap_font_ko[s_index];
    s_buffer[s_count + 1] |= g_mz_bitmap_font_ko[s_index + 1];
   }
  }
  if(s_c2 != 0xff)
  {
   s_index = (s_b2 * 27 * 32) + (s_c2 * 32) + (s_count) + 4864 + 2688;
   if(s_index < 11008)
   {
    s_buffer[s_count] |= g_mz_bitmap_font_ko[s_index];
    s_buffer[s_count + 1] |= g_mz_bitmap_font_ko[s_index + 1];
   }
  }
 }
}

static void mz_get_bitmap_en(void *s_bitmap, int s_code)
{
 s_code &= 0x7f;
 (void)memcpy(s_bitmap, (void *)(&g_mz_bitmap_font_en[s_code << 4]), (size_t)16);
}

static void mz_draw_pixel(struct ts_vfb *s_vfb, int s_color, int s_x, int s_y)
{
 void *s_to;
 if((s_x < 0) || (s_y < 0) || (s_x >= s_vfb->resx) || (s_y >= s_vfb->resy))return;
 s_to = (void *)(((unsigned char *)s_vfb->map) + (s_y * s_vfb->line_length) + (s_x * (s_vfb->bpp >> 3)));
 switch(s_vfb->bpp)
 {
  case  8: *((unsigned char *)s_to) = (unsigned char)s_color; break;
  case 16: *((unsigned short *)s_to) = (unsigned short)s_color; break;
  case 32: *((unsigned long *)s_to) = (unsigned long)s_color; break;
  default: /* not supported */ break;
 } 
}

static unsigned int mz_get_pixel(struct ts_vfb *s_vfb, int s_x, int s_y)
{
 unsigned int s_color;
 void *s_from;
 if((s_x < 0) || (s_y < 0) || (s_x >= s_vfb->resx) || (s_y >= s_vfb->resy))return(0u);
 s_from = (void *)(((unsigned char *)s_vfb->map) + (s_y * s_vfb->line_length) + (s_x * (s_vfb->bpp >> 3)));
 switch(s_vfb->bpp)
 {
  case  8: s_color = (unsigned int)(*((unsigned char *)s_from)); break;
  case 16: s_color = (unsigned int)(*((unsigned short *)s_from)); break;
  case 32: s_color = (unsigned int)(*((unsigned long *)s_from)); break;
  default: s_color = 0; /* not supported */ break;
 }
 return(s_color); 
}

static void mz_draw_update(struct ts_vfb *s_vfb)
{
 int s_x, s_y;
 unsigned int s_color;
 for(s_y = 0;s_y < s_vfb->resy;s_y++)
 {
  s_x = 0;
  while(s_x < s_vfb->resx)
  {
   s_color = mz_get_pixel(s_vfb, s_x, s_y);
   if((s_color >= ' ') && (s_color <= 0x7f))(void)fputc(s_color, stdout);
   else fputc('.', stdout);
   s_x++; 
  }
  while(s_x < (s_vfb->resx + s_vfb->shadow))
  {
   (void)fputs("X", stdout); 
   s_x++; 
  }
  (void)fputs("\n", stdout); 
 }
 (void)fflush(stdout);
}

static void mz_draw_putc_en(struct ts_vfb *s_vfb, int s_code, int s_fcolor, int s_bcolor, int s_x, int s_y)
{
 int s_cx, s_cy;
 unsigned char s_bitmap[ 16 ];
 mz_get_bitmap_en((void *)(&s_bitmap[0]), s_code);
 for(s_cy = 0;s_cy < 16;s_cy++)
 {
  for(s_cx = 0;s_cx < 8;s_cx++)
  {
   mz_draw_pixel(s_vfb, (s_bitmap[s_cy] & ((1 << (7 - s_cx)))) ? s_fcolor : s_bcolor, s_x + s_cx, s_y + s_cy);
  }
 }
}

static void mz_draw_putc_ko(struct ts_vfb *s_vfb, int s_code, int s_fcolor, int s_bcolor, int s_x, int s_y)
{
 int s_cx, s_cy;
 unsigned char s_bitmap[ 16 << 1 ];
 unsigned short s_word = (unsigned short)s_code;
 mz_convert_ks_to_johab((unsigned short *)(&s_word));
 mz_get_bitmap_johab((void *)(&s_bitmap[0]), s_word);
 for(s_cy = 0;s_cy < 16;s_cy++)
 {
  s_cx = 0;
  while(s_cx < 8)
  {
   mz_draw_pixel(s_vfb, (s_bitmap[(s_cy << 1)] & ((1 << (7 - s_cx)))) ? s_fcolor : s_bcolor, s_x + s_cx, s_y + s_cy);
   mz_draw_pixel(s_vfb, (s_bitmap[(s_cy << 1) + 1] & ((1 << (7 - s_cx)))) ? s_fcolor : s_bcolor, s_x + s_cx + 8, s_y + s_cy);
   s_cx++;
  }
 }
}

static void mz_draw_puts(struct ts_vfb *s_vfb, const char *s_string, int s_fcolor, int s_bcolor, int s_x, int s_y)
{
 int s_byte;
 do
 {
  s_byte = (int)(*((unsigned char *)(s_string++)));
  if(s_byte == 0)break; 
  if(s_byte & 0x80)
  {
   s_byte = (s_byte << 8) | ((int)(*((unsigned char *)(s_string++))));
   mz_draw_putc_ko(s_vfb, s_byte, s_fcolor, s_bcolor, s_x, s_y);
   s_x += 16;
  }
  else
  {
   mz_draw_putc_en(s_vfb, s_byte, s_fcolor, s_bcolor, s_x, s_y);
   s_x += 8;
  } 
 }while(1); 
}

int main(void)
{
 struct ts_vfb s_console_fb;
 struct ts_vfb *s_vfb = (struct ts_vfb *)(&s_console_fb);
 
 s_vfb->bpp = 8;
 s_vfb->resx = 80;
 s_vfb->resy = 16 * 2;
 s_vfb->shadow = 0;
 s_vfb->line_length = (s_vfb->resx + s_vfb->shadow) * (s_vfb->bpp >> 3);
 s_vfb->map_size = (size_t)(s_vfb->line_length * s_vfb->resy);
 s_vfb->map = (void *)memset(malloc(s_vfb->map_size), 0, s_vfb->map_size);
 
 if(s_vfb->map != ((void *)0))
 {
  mz_draw_puts(s_vfb, "ѱ̵ǿ", 'O', 0, 0, 0); 
  mz_draw_puts(s_vfb, "by minzkn", 'O', 0, 0, 16); 
  mz_draw_update(s_vfb);
  free(s_vfb->map);
 }
 else (void)fprintf(stderr, "error: map\n");
 return(0);
}

/* End of source */
