###
### Copyright (C) HWPORT.COM
### All rights reserved.
### Author: JAEHYUK CHO <mailto:minzkn@minzkn.com>
###

CROSS_COMPILE                ?=#

CC                           :=$(CROSS_COMPILE)gcc#
LD                           :=$(CROSS_COMPILE)ld#
STRIP                        :=$(CROSS_COMPILE)strip#
RM                           :=rm -f#

CFLAGS_VENDOR                :=#
LDFLAGS_VENDOR               :=#
LDFLAGS_SHARED_VENDOR        :=#

CFLAGS                       :=#
CFLAGS                       +=-Os#
CFLAGS                       +=-pipe#
CFLAGS                       +=-fPIC#
CFLAGS                       +=-fPIE# for shared-object
CFLAGS                       +=-fomit-frame-pointer#
#CFLAGS                       +=-ansi#
CFLAGS                       +=-Wall -W#
CFLAGS                       +=-Wshadow#
CFLAGS                       +=-Wcast-qual#
#CFLAGS                       +=-Wcast-align#
CFLAGS                       +=-Wpointer-arith#
CFLAGS                       +=-Wbad-function-cast#
CFLAGS                       +=-Wstrict-prototypes#
CFLAGS                       +=-Wmissing-prototypes#
CFLAGS                       +=-Wmissing-declarations#
CFLAGS                       +=-Wnested-externs#
CFLAGS                       +=-Winline#
CFLAGS                       +=-Wwrite-strings#
CFLAGS                       +=-Wchar-subscripts#
CFLAGS                       +=-Wformat#
CFLAGS                       +=-Wformat-security#
CFLAGS                       +=-Wimplicit#
CFLAGS                       +=-Wmain#
CFLAGS                       +=-Wmissing-braces#
CFLAGS                       +=-Wnested-externs#
CFLAGS                       +=-Wparentheses#
CFLAGS                       +=-Wredundant-decls#
CFLAGS                       +=-Wreturn-type#
CFLAGS                       +=-Wsequence-point#
CFLAGS                       +=-Wsign-compare#
CFLAGS                       +=-Wswitch#
CFLAGS                       +=-Wuninitialized#
CFLAGS                       +=-Wunknown-pragmas#
CFLAGS                       +=-Wcomment#
CFLAGS                       +=-Wundef#
CFLAGS                       +=-Wunused#
#CFLAGS                       +=-Wunreachable-code#
#CFLAGS                       +=-Wconversion#
#CFLAGS                       +=-Wpadded#

CFLAGS                       +=-U_FORTIFY_SOURCE -D_FORTIFY_SOURCE=0#
CFLAGS                       +=-D_REENTRANT#
CFLAGS                       +=-D_LARGEFILE_SOURCE -D_LARGEFILE64_SOURCE -D_FILE_OFFSET_BITS=64 -D_LFS64_LARGEFILE=1#

LDFLAGS                      :=#
LDFLAGS                      +=-s#
LDFLAGS                      +=-fPIE -pie#

LDFLAGS_SHARED               :=#

TARGET                       :=netlink_rtnetlink_monitor#

.PHONY: all clean

all: $(TARGET)

clean:
	$(RM) *.o $(TARGET)

# Cavium_Networks tool-chain detect
PATH_CAVIUM_NETWORK :=$(wildcard /usr/local/Cavium_Networks)#
ifeq ($(PATH_CAVIUM_NETWORK),)
PATH_CAVIUM_NETWORK :=$(wildcard /opt/XTM-ramdisk-Cavium_Networks/Cavium_Networks)#
endif
ifeq ($(PATH_CAVIUM_NETWORK),)
PATH_CAVIUM_NETWORK :=$(wildcard /opt/XTM-firmware-Cavium_Networks/Cavium_Networks)#
endif
.PHONY: xtm mips-xtm mips-xtm-linux-gnu mips-xtm-linux-glibc
xtm: mips-xtm
mips-xtm: mips-xtm-linux-gnu
mips-xtm-linux-gnu mips-xtm-linux-glibc:
	PATH="$(wildcard $(PATH_CAVIUM_NETWORK)/OCTEON-SDK/tools/bin):${PATH}" \
	$(MAKE) \
	CFLAGS_VENDOR="-mabi=n32" \
	LDFLAGS_VENDOR="-mabi=n32 -melf32btsmipn32" \
	LDFLAGS_SHARED_VENDOR="-mabi=n32 -Wl,-melf32btsmipn32" \
	CROSS_COMPILE="mips64-octeon-linux-gnu-" \
	--no-print-directory all

netlink_rtnetlink_monitor: netlink_rtnetlink_monitor.o
	$(CC) $(LDFLAGS_VENDOR) $(LDFLAGS) -o $(@) $(^)
	$(STRIP) --remove-section=.comment --remove-section=.note $(@)

%.o: %.c makefile
	$(CC) $(CFLAGS_VENDOR) $(CFLAGS) -c -o $(@) $(<)

# End of makefile
