/*
 Copyright (C) JAEHYUK CHO
 All rights reserved.
 Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#if !defined(__def_mzapi_source_main_c__)
#define __def_mzapi_source_main_c__ "main.c"

#include <stdio.h>
#include <stdlib.h>

#include "mzudev.h"

int main(void);

int main(void)
{
    int s_socket;
    mzudev_event_t *s_event_head, *s_event;

    (void)fprintf(stdout, "enter mzudev test.\n");

    s_socket = mzudev_open_netlink();
    if(s_socket == (-1)) {
        perror("mzudev_open_netlink");
        return(EXIT_FAILURE);
    }
    
    s_event_head = (mzudev_event_t *)0;
    for(;;) {
        s_event = mzudev_get_event(s_socket, 1000);
        if(s_event == ((mzudev_event_t *)0)) {
            (void)fprintf(stdout, "wait event {\n");
	    s_event = s_event_head;
	    while(s_event != ((mzudev_event_t *)0)) {
	        (void)fprintf(stdout, "\t%s (SUBSYSTEM=\"%s\")\n", s_event->devpath, mzudev_get_env(s_event, "SUBSYSTEM"));
                s_event = s_event->next;
	    }
	    (void)fprintf(stdout, "}\n");
            continue;
        }

        do {
            int s_env_count;

            (void)fprintf(stdout, "\x1b[1;33mmzudev event (%lu bytes)\x1b[0m \"\x1b[1;37m%s\x1b[0m\" (%s@%s) {\n",
                (unsigned long)s_event->size,
                s_event->title,
                mzudev_get_env(s_event, "ACTION"),
                mzudev_get_env(s_event, "DEVPATH")
            );
            for(s_env_count = 0;s_env_count < s_event->env_count;s_env_count++) {
                (void)fprintf(stdout, "\t%s = %s\n",
                    (s_event->env[s_env_count].name == ((char *)0)) ? "<NONAME>" : s_event->env[s_env_count].name,
                    (s_event->env[s_env_count].value == ((char *)0)) ? "<NOVALUE>" : s_event->env[s_env_count].value);
            }
            (void)fprintf(stdout, "}\n");
        }while(0);
    
        s_event_head = mzudev_update_event(s_event_head, s_event);
    }
    s_event_head = mzudev_free_event(s_event_head);

    s_socket = mzudev_close_netlink(s_socket);
        
    (void)fprintf(stdout, "leave mzudev test.\n");

    return(EXIT_SUCCESS);
}

#endif

/* vim: set expandtab: */
/* End of source */
