/*
 Copyright (C) JAEHYUK CHO
 All rights reserved.
 Code by JaeHyuk Cho <mailto:minzkn@minzkn.com>
*/

#if !defined(__def_mzapi_header_mzudev_h__)
#define __def_mzapi_header_mzudev_h__ "mzudev.h"

#include <sys/types.h>

typedef struct mzudev_env_ts {
    char *name;
    char *value;
}__mzudev_env_t;
#define mzudev_env_t __mzudev_env_t

typedef struct mzudev_event_ts {
    struct mzudev_event_ts *prev;
    struct mzudev_event_ts *next;

    int env_count;
    __mzudev_env_t *env;

    size_t size;
    unsigned char *data;

    char *title;
    char *action;
    char *devpath;
}__mzudev_event_t;
#define mzudev_event_t __mzudev_event_t

#if !defined(__def_mzapi_source_mzudev_c__)
#if defined(__cplusplus)
extern "C" {
#endif

extern int mzudev_open_netlink(void);
extern int mzudev_close_netlink(int s_socket);
extern int mzudev_check_event(int s_socket, int s_msec);
extern mzudev_event_t *mzudev_get_event(int s_socket, int s_msec);
extern mzudev_event_t *mzudev_update_event(mzudev_event_t *s_head, mzudev_event_t *s_event);
extern mzudev_event_t *mzudev_free_event(mzudev_event_t *s_event);
extern char *mzudev_get_env(mzudev_event_t *s_event, const char *s_name);

#if defined(__cplusplus)
}
#endif
#endif

#endif

/* vim: set expandtab: */
/* End of source */
